/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.jaybird.util.StringUtils;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.AbstractKeysMethod;
import org.firebirdsql.jdbc.metadata.Clause;

public final class GetCrossReference
extends AbstractKeysMethod {
    private static final String GET_CROSS_KEYS_START = "select\n  PK.RDB$RELATION_NAME as PKTABLE_NAME,\n  ISP.RDB$FIELD_NAME as PKCOLUMN_NAME,\n  FK.RDB$RELATION_NAME as FKTABLE_NAME,\n  ISF.RDB$FIELD_NAME as FKCOLUMN_NAME,\n  ISP.RDB$FIELD_POSITION + 1 as KEY_SEQ,\n  RC.RDB$UPDATE_RULE as UPDATE_RULE,\n  RC.RDB$DELETE_RULE as DELETE_RULE,\n  PK.RDB$CONSTRAINT_NAME as PK_NAME,\n  FK.RDB$CONSTRAINT_NAME as FK_NAME,\n  PK.RDB$INDEX_NAME as JB_PK_INDEX_NAME,\n  FK.RDB$INDEX_NAME as JB_FK_INDEX_NAME\nfrom RDB$RELATION_CONSTRAINTS PK\ninner join RDB$REF_CONSTRAINTS RC\n  on PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ\ninner join RDB$RELATION_CONSTRAINTS FK\n  on FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME\ninner join RDB$INDEX_SEGMENTS ISP\n  on ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME\ninner join RDB$INDEX_SEGMENTS ISF\n  on ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION\nwhere ";
    private static final String GET_CROSS_KEYS_END = "\norder by FK.RDB$RELATION_NAME, ISP.RDB$FIELD_POSITION";

    private GetCrossReference(DbMetadataMediator mediator) {
        super(mediator);
    }

    public ResultSet getCrossReference(String primaryTable, String foreignTable) throws SQLException {
        if (StringUtils.isNullOrEmpty(primaryTable) || StringUtils.isNullOrEmpty(foreignTable)) {
            return this.createEmpty();
        }
        Clause primaryTableClause = Clause.equalsClause("PK.RDB$RELATION_NAME", primaryTable);
        Clause foreignTableCause = Clause.equalsClause("FK.RDB$RELATION_NAME", foreignTable);
        String sql = GET_CROSS_KEYS_START + Clause.conjunction(primaryTableClause, foreignTableCause) + GET_CROSS_KEYS_END;
        DbMetadataMediator.MetadataQuery metadataQuery = new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(primaryTableClause, foreignTableCause));
        return this.createMetaDataResultSet(metadataQuery);
    }

    public static GetCrossReference create(DbMetadataMediator mediator) {
        return new GetCrossReference(mediator);
    }
}

