/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.slice;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;

public final class PObjectSlice
extends PSlice {
    protected final Object startObject;
    protected final Object stopObject;
    protected final Object stepObject;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger ZERO = BigInteger.ZERO;

    public PObjectSlice(PythonLanguage lang, Object start, Object stop, Object step) {
        super(lang);
        this.startObject = start;
        this.stopObject = stop;
        this.stepObject = step;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder("slice(");
        str.append(this.getStart()).append(", ");
        str.append(this.getStop()).append(", ");
        str.append(this.getStep());
        return str.append(")").toString();
    }

    @Override
    public final Object getStart() {
        return this.startObject;
    }

    @Override
    public final Object getStop() {
        return this.stopObject;
    }

    @Override
    public final Object getStep() {
        return this.stepObject;
    }

    public PSlice.SliceInfo computeIndices(int length) {
        return PSlice.computeIndices(this.getStart(), this.getStop(), this.getStep(), length);
    }

    private static boolean pyLT(BigInteger left, BigInteger right) {
        return left.compareTo(right) < 0;
    }

    private static boolean pyGT(BigInteger left, BigInteger right) {
        return left.compareTo(right) > 0;
    }

    private static int pySign(BigInteger n) {
        return n.compareTo(ZERO);
    }

    @CompilerDirectives.TruffleBoundary
    public static SliceObjectInfo computeIndicesSlowPath(PObjectSlice slice, Object lengthIn, boolean usePInt) {
        BigInteger stop;
        BigInteger start;
        BigInteger upper;
        BigInteger lower;
        boolean stepIsNegative;
        BigInteger step;
        BigInteger length = (BigInteger)lengthIn;
        if (PObjectSlice.pySign(length) < 0) {
            throw PRaiseNode.raiseStatic(null, PythonErrorType.ValueError, ErrorMessages.LENGTH_SHOULD_NOT_BE_NEG);
        }
        if (slice.getStep() == PNone.NONE) {
            step = ONE;
            stepIsNegative = false;
        } else {
            step = (BigInteger)slice.getStep();
            boolean bl = stepIsNegative = PObjectSlice.pySign(step) < 0;
            if (PObjectSlice.pySign(step) == 0) {
                throw PRaiseNode.raiseStatic(null, PythonErrorType.ValueError, ErrorMessages.SLICE_STEP_CANNOT_BE_ZERO);
            }
        }
        if (stepIsNegative) {
            lower = BigInteger.valueOf(-1L);
            upper = lower.add(length);
        } else {
            lower = ZERO;
            upper = length;
        }
        if (slice.getStart() == PNone.NONE) {
            start = stepIsNegative ? upper : lower;
        } else {
            start = (BigInteger)slice.getStart();
            if (PObjectSlice.pySign(start) < 0) {
                if (PObjectSlice.pyLT(start = start.add(length), lower)) {
                    start = lower;
                }
            } else if (PObjectSlice.pyGT(start, upper)) {
                start = upper;
            }
        }
        if (slice.getStop() == PNone.NONE) {
            stop = stepIsNegative ? lower : upper;
        } else {
            stop = (BigInteger)slice.getStop();
            if (PObjectSlice.pySign(stop) < 0) {
                if (PObjectSlice.pyLT(stop = stop.add(length), lower)) {
                    stop = lower;
                }
            } else if (PObjectSlice.pyGT(stop, upper)) {
                stop = upper;
            }
        }
        if (usePInt) {
            PythonLanguage language = PythonLanguage.get(null);
            return new SliceObjectInfo(PFactory.createInt(language, start), PFactory.createInt(language, stop), PFactory.createInt(language, step));
        }
        return new SliceObjectInfo(start, stop, step);
    }

    @CompilerDirectives.ValueType
    public static final class SliceObjectInfo {
        public final Object start;
        public final Object stop;
        public final Object step;

        public SliceObjectInfo(Object start, Object stop, Object step) {
            this.start = start;
            this.stop = stop;
            this.step = step;
        }
    }
}

