/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.asyncio;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.asyncio.CoroutineWrapperBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.asyncio.PCoroutineWrapper;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCoroutineWrapper})
public final class CoroutineWrapperBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CoroutineWrapperBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CoroutineWrapperBuiltinsFactory.getFactories();
    }

    @Builtin(name="close", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1, declaresExplicitSelf=true)
    @GenerateNodeFactory
    public static abstract class CloseNode
    extends PythonBuiltinNode {
        @Specialization
        public Object doThrow(VirtualFrame frame, PCoroutineWrapper self, @Cached CommonGeneratorBuiltins.CloseNode closeNode) {
            return closeNode.execute(frame, self.coroutine);
        }
    }

    @Builtin(name="throw", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=4)
    @GenerateNodeFactory
    public static abstract class ThrowNode
    extends PythonBuiltinNode {
        @Specialization
        public Object doThrow(VirtualFrame frame, PCoroutineWrapper self, Object typ, Object val, Object tp, @Cached CommonGeneratorBuiltins.ThrowNode throwNode) {
            return throwNode.execute(frame, self.coroutine, typ, val, tp);
        }
    }

    @Builtin(name="send", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object doSend(VirtualFrame frame, PCoroutineWrapper self, Object arg, @Cached CommonGeneratorBuiltins.SendNode send) {
            return send.execute(frame, self.coroutine, arg);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        public Object doNext(VirtualFrame frame, PCoroutineWrapper self, @Cached CommonGeneratorBuiltins.SendNode send) {
            return send.execute(frame, self.coroutine, PNone.NONE);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object getIter(PCoroutineWrapper self) {
            return self;
        }
    }
}

