/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuggestedReplacement {
    private String replacement;
    private String shortDescription;
    private String suffix;
    private SortedMap<String, Float> features = Collections.emptySortedMap();
    private Float confidence = null;
    private SuggestionType type = SuggestionType.Default;

    public SuggestedReplacement(String replacement) {
        this(replacement, null, null);
    }

    public SuggestedReplacement(String replacement, String shortDescription) {
        this(replacement, shortDescription, null);
    }

    public SuggestedReplacement(String replacement, String shortDescription, String suffix) {
        this.replacement = Objects.requireNonNull(replacement);
        this.shortDescription = shortDescription;
        this.suffix = suffix;
    }

    public SuggestedReplacement(SuggestedReplacement repl) {
        this.replacement = repl.replacement;
        this.suffix = repl.suffix;
        this.setShortDescription(repl.getShortDescription());
        this.setConfidence(repl.getConfidence());
        this.setFeatures(repl.getFeatures());
        this.setType(repl.getType());
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = Objects.requireNonNull(replacement);
    }

    @Nullable
    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String desc) {
        this.shortDescription = desc;
    }

    public void setType(SuggestionType type) {
        this.type = Objects.requireNonNull(type);
    }

    @NotNull
    public SuggestionType getType() {
        return this.type;
    }

    @Nullable
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String val) {
        this.suffix = val;
    }

    public String toString() {
        return this.replacement + "(" + this.shortDescription + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestedReplacement that = (SuggestedReplacement)o;
        return this.replacement.equals(that.replacement) && Objects.equals(this.shortDescription, that.shortDescription);
    }

    public int hashCode() {
        return Objects.hash(this.replacement, this.shortDescription);
    }

    @Nullable
    public Float getConfidence() {
        return this.confidence;
    }

    public void setConfidence(@Nullable Float confidence) {
        this.confidence = confidence;
    }

    @NotNull
    public SortedMap<String, Float> getFeatures() {
        return Collections.unmodifiableSortedMap(this.features);
    }

    public void setFeatures(@NotNull SortedMap<String, Float> features) {
        this.features = features;
    }

    public static List<SuggestedReplacement> convert(List<String> suggestions) {
        return suggestions.stream().map(SuggestedReplacement::new).collect(Collectors.toList());
    }

    public static List<SuggestedReplacement> topMatch(String word) {
        return SuggestedReplacement.topMatch(word, null);
    }

    public static List<SuggestedReplacement> topMatch(String word, String shortDesc) {
        SuggestedReplacement sugg = new SuggestedReplacement(word, shortDesc);
        sugg.setConfidence(Float.valueOf(0.99f));
        return Collections.singletonList(sugg);
    }

    public static enum SuggestionType {
        Default,
        Translation,
        Curated;

    }
}

