/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.MultiplatformKt;
import org.jetbrains.plugins.textmate.language.TextMateInterner;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.RawLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxIncludeRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNode;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxRawNodeImpl;
import org.jetbrains.plugins.textmate.language.syntax.TextMateRawCapture;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTableCore;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J)\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u0018H\u0002\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\"\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder;", "", "interner", "Lorg/jetbrains/plugins/textmate/language/TextMateInterner;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/TextMateInterner;)V", "currentRuleId", "Lkotlin/concurrent/atomics/AtomicInt;", "Ljava/util/concurrent/atomic/AtomicInteger;", "syntaxNodes", "Lkotlin/concurrent/atomics/AtomicReference;", "Lkotlinx/collections/immutable/PersistentMap;", "", "Lorg/jetbrains/plugins/textmate/language/syntax/RawLanguageDescriptor;", "Ljava/util/concurrent/atomic/AtomicReference;", "addSyntax", "plist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "build", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableCore;", "loadLanguageDescriptor", "loadRealNode", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNodeImpl;", "parentBuilder", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;", "loadNestedSyntax", "loadCaptures", "", "Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "captures", "parent", "(Lorg/jetbrains/plugins/textmate/plist/Plist;Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxRawNode;)[Lorg/jetbrains/plugins/textmate/language/syntax/TextMateRawCapture;", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nTextMateSyntaxTableBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,340:1\n216#2,2:341\n1869#3,2:343\n1563#3:345\n1634#3,3:346\n1869#3,2:349\n1869#3,2:351\n1869#3,2:353\n1869#3,2:355\n*S KotlinDebug\n*F\n+ 1 TextMateSyntaxTableBuilder.kt\norg/jetbrains/plugins/textmate/language/syntax/TextMateSyntaxTableBuilder\n*L\n44#1:341,2\n50#1:343,2\n63#1:345\n63#1:346,3\n98#1:349,2\n103#1:351,2\n125#1:353,2\n142#1:355,2\n*E\n"})
public final class TextMateSyntaxTableBuilder {
    @NotNull
    private final TextMateInterner interner;
    @NotNull
    private final AtomicInteger currentRuleId;
    @NotNull
    private final AtomicReference<PersistentMap<CharSequence, RawLanguageDescriptor>> syntaxNodes;

    public TextMateSyntaxTableBuilder(@NotNull TextMateInterner interner) {
        Intrinsics.checkNotNullParameter((Object)interner, (String)"interner");
        this.interner = interner;
        this.currentRuleId = new AtomicInteger(0);
        this.syntaxNodes = new AtomicReference<PersistentMap>(ExtensionsKt.persistentMapOf());
    }

    @Nullable
    public final CharSequence addSyntax(@NotNull Plist plist) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
        RawLanguageDescriptor rawLanguageDescriptor = this.loadLanguageDescriptor(plist);
        if (rawLanguageDescriptor != null) {
            RawLanguageDescriptor languageDescriptor = rawLanguageDescriptor;
            boolean bl = false;
            MultiplatformKt.update(this.syntaxNodes, arg_0 -> TextMateSyntaxTableBuilder.addSyntax$lambda$0$0(languageDescriptor, arg_0));
            charSequence = languageDescriptor.getScopeName();
        } else {
            charSequence = null;
        }
        return charSequence;
    }

    @NotNull
    public final TextMateSyntaxTableCore build() {
        Map ruleIdToReferenceRuleId = new LinkedHashMap();
        Map compiledRules = new LinkedHashMap();
        Map languageDescriptors = new LinkedHashMap();
        TextMateSyntaxTableCore syntaxTable = new TextMateSyntaxTableCore(languageDescriptors);
        PersistentMap<CharSequence, RawLanguageDescriptor> syntaxNodes = this.syntaxNodes.get();
        Map $this$forEach$iv = (Map)syntaxNodes;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TextMateLanguageDescriptor compiledNode;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            CharSequence scopeName = (CharSequence)entry.getKey();
            RawLanguageDescriptor rawLanguageDescriptor = (RawLanguageDescriptor)entry.getValue();
            if (rawLanguageDescriptor.compile((Map)syntaxNodes, compiledRules, ruleIdToReferenceRuleId, syntaxTable) == null) continue;
            boolean bl2 = false;
            languageDescriptors.put(scopeName, compiledNode);
        }
        SyntaxNodeDescriptor[] rulesRepository = new SyntaxNodeDescriptor[ruleIdToReferenceRuleId.size()];
        Iterable $this$forEach$iv2 = ruleIdToReferenceRuleId.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            rulesRepository[((Number)it.getValue()).intValue()] = compiledRules.get(it.getKey());
        }
        syntaxTable.setRulesRepository$intellij_textmate_core(rulesRepository);
        return syntaxTable;
    }

    /*
     * WARNING - void declaration
     */
    private final RawLanguageDescriptor loadLanguageDescriptor(Plist plist) {
        String scopeNameValue;
        PListValue scopeNamePlistValue;
        PListValue pListValue = scopeNamePlistValue = plist.getPlistValue(Constants.StringKey.SCOPE_NAME.getValue());
        String string = scopeNameValue = pListValue != null ? pListValue.getString() : null;
        if (scopeNameValue != null) {
            List list;
            SyntaxRawNodeImpl rootSyntaxRawNode = this.loadRealNode(plist, null);
            Object object = plist.getPlistValue("injections");
            if (object != null && (object = ((PListValue)object).getPlist()) != null && (object = ((Plist)object).entries()) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String key = (String)entry.getKey();
                    PListValue value = (PListValue)entry.getValue();
                    collection.add(TuplesKt.to((Object)key, (Object)this.loadRealNode(value.getPlist(), rootSyntaxRawNode)));
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List rawInjections = list;
            return new RawLanguageDescriptor(this.interner.intern(scopeNameValue), rootSyntaxRawNode, rawInjections);
        }
        return null;
    }

    private final SyntaxRawNodeImpl loadRealNode(Plist plist, SyntaxRawNode parentBuilder) {
        int ruleId = AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId);
        SyntaxRawNodeImpl result = new SyntaxRawNodeImpl(ruleId, parentBuilder);
        for (Map.Entry<String, PListValue> entry : plist.entries()) {
            Iterable $this$forEach$iv;
            PListValue pListValue = entry.getValue();
            String key = entry.getKey();
            Constants.StringKey stringKey = Constants.StringKey.Companion.fromName(key);
            if (stringKey != null) {
                if (pListValue.getString() != null) {
                    String stringValue;
                    boolean bl = false;
                    result.setStringAttribute(stringKey, this.interner.intern(stringValue));
                }
                continue;
            }
            Constants.CaptureKey captureKey = Constants.CaptureKey.Companion.fromName(key);
            if (captureKey != null) {
                if (this.loadCaptures(pListValue.getPlist(), result) != null) {
                    TextMateRawCapture[] captures;
                    boolean bl = false;
                    result.setCaptures(captureKey, captures);
                }
                continue;
            }
            if (StringsKt.equals((String)"repository", (String)key, (boolean)true)) {
                $this$forEach$iv = pListValue.getPlist().entries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Map.Entry entry2 = (Map.Entry)element$iv;
                    boolean bl = false;
                    String key2 = (String)entry2.getKey();
                    PListValue value = (PListValue)entry2.getValue();
                    result.appendRepository(key2, this.loadNestedSyntax(value.getPlist(), result));
                }
                continue;
            }
            if (!StringsKt.equals((String)"patterns", (String)key, (boolean)true)) continue;
            $this$forEach$iv = pListValue.getArray();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PListValue value = (PListValue)element$iv;
                boolean bl = false;
                result.addChild(this.loadNestedSyntax(value.getPlist(), result));
            }
        }
        return result;
    }

    private final SyntaxRawNode loadNestedSyntax(Plist plist, SyntaxRawNodeImpl parentBuilder) {
        PListValue pListValue = plist.getPlistValue("include");
        String include = pListValue != null ? pListValue.getString() : null;
        return include != null ? (SyntaxRawNode)new SyntaxIncludeRawNode(AtomicsKt.fetchAndIncrement((AtomicInteger)this.currentRuleId), parentBuilder, include) : (SyntaxRawNode)this.loadRealNode(plist, parentBuilder);
    }

    private final TextMateRawCapture[] loadCaptures(Plist captures, SyntaxRawNode parent) {
        Map map = new LinkedHashMap();
        int maxGroupIndex = 0;
        maxGroupIndex = -1;
        Iterable $this$forEach$iv = captures.entries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            PListValue value = (PListValue)entry.getValue();
            Integer n = StringsKt.toIntOrNull((String)key);
            if (n == null) continue;
            int index = ((Number)n).intValue();
            boolean bl2 = false;
            Plist captureDict = value.getPlist();
            PListValue captureName = captureDict.getPlistValue("name");
            if (captureName != null) {
                Integer n2 = index;
                String string = captureName.getString();
                if (string == null) {
                    string = "";
                }
                map.put(n2, new TextMateRawCapture.Name(this.interner.intern(string)));
            } else {
                map.put(index, new TextMateRawCapture.Rule(this.loadRealNode(captureDict, parent)));
            }
            maxGroupIndex = Math.max(maxGroupIndex, index);
        }
        if (maxGroupIndex < 0 || map.isEmpty()) {
            return null;
        }
        TextMateRawCapture[] result = new TextMateRawCapture[maxGroupIndex + 1];
        Iterable $this$forEach$iv2 = map.entrySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Map.Entry e = (Map.Entry)element$iv;
            boolean bl = false;
            result[((Number)e.getKey()).intValue()] = e.getValue();
        }
        return result;
    }

    private static final PersistentMap addSyntax$lambda$0$0(RawLanguageDescriptor $languageDescriptor, PersistentMap it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.put((Object)$languageDescriptor.getScopeName(), (Object)$languageDescriptor);
    }
}

