/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.licensing;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;

public final class Ed25519 {
    private static final BigInteger P = new BigInteger("7fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffed", 16);
    private static final BigInteger L = new BigInteger("1000000000000000000000000000000014def9dea2f79cd65812631a5cf5d3ed", 16);
    private static final BigInteger D;
    private static final BigInteger SQRT_M1;
    private static final BigInteger BX;
    private static final BigInteger BY;
    private static final Point B;
    private static final Point ID;

    private Ed25519() {
    }

    public static KeyPair generateKeyPair(SecureRandom rnd) {
        byte[] seed = new byte[32];
        rnd.nextBytes(seed);
        byte[] pub = Ed25519.publicKeyFromSeed(seed);
        return new KeyPair(seed, pub);
    }

    public static byte[] publicKeyFromSeed(byte[] seed32) {
        if (seed32 == null || seed32.length != 32) {
            throw new IllegalArgumentException("seed must be 32 bytes");
        }
        Digest d = Ed25519.sha512(new byte[][]{seed32});
        byte[] aBytes = Ed25519.clamp(Arrays.copyOfRange(d.bytes, 0, 32));
        BigInteger a = Ed25519.leToInt(aBytes);
        Point A = Ed25519.scalarMulBase(a);
        return Ed25519.encodePoint(A);
    }

    public static byte[] sign(byte[] seed32, byte[] message) {
        if (seed32 == null || seed32.length != 32) {
            throw new IllegalArgumentException("seed must be 32 bytes");
        }
        if (message == null) {
            message = new byte[]{};
        }
        Digest h = Ed25519.sha512(new byte[][]{seed32});
        byte[] aBytes = Ed25519.clamp(Arrays.copyOfRange(h.bytes, 0, 32));
        byte[] prefix = Arrays.copyOfRange(h.bytes, 32, 64);
        BigInteger a = Ed25519.leToInt(aBytes);
        byte[] Aenc = Ed25519.encodePoint(Ed25519.scalarMulBase(a));
        Digest rDig = Ed25519.sha512(prefix, message);
        BigInteger r = Ed25519.leToInt(rDig.bytes).mod(L);
        byte[] Renc = Ed25519.encodePoint(Ed25519.scalarMulBase(r));
        Digest kDig = Ed25519.sha512(Renc, Aenc, message);
        BigInteger k = Ed25519.leToInt(kDig.bytes).mod(L);
        BigInteger S = r.add(k.multiply(a)).mod(L);
        byte[] sig = new byte[64];
        System.arraycopy(Renc, 0, sig, 0, 32);
        System.arraycopy(Ed25519.intToLe(S, 32), 0, sig, 32, 32);
        return sig;
    }

    public static boolean verify(byte[] publicKey32, byte[] message, byte[] signature64) {
        if (publicKey32 == null || publicKey32.length != 32) {
            return false;
        }
        if (signature64 == null || signature64.length != 64) {
            return false;
        }
        if (message == null) {
            message = new byte[]{};
        }
        try {
            byte[] Renc = Arrays.copyOfRange(signature64, 0, 32);
            byte[] Senc = Arrays.copyOfRange(signature64, 32, 64);
            BigInteger S = Ed25519.leToInt(Senc);
            if (S.signum() < 0 || S.compareTo(L) >= 0) {
                return false;
            }
            Point A = Ed25519.decodePoint(publicKey32);
            Point R = Ed25519.decodePoint(Renc);
            Digest kDig = Ed25519.sha512(Renc, publicKey32, message);
            BigInteger k = Ed25519.leToInt(kDig.bytes).mod(L);
            Point left = Ed25519.scalarMulBase(S);
            Point right = Ed25519.add(R, Ed25519.scalarMul(A, k));
            return left.equals(right);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static Digest sha512(byte[] ... parts) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            for (byte[] p : parts) {
                md.update(p);
            }
            return new Digest(md.digest());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static byte[] clamp(byte[] a) {
        a[0] = (byte)(a[0] & 0xFFFFFFF8);
        a[31] = (byte)(a[31] & 0x7F);
        a[31] = (byte)(a[31] | 0x40);
        return a;
    }

    private static byte[] intToLe(BigInteger x, int len) {
        byte[] be = x.toByteArray();
        if (be.length > 1 && be[0] == 0) {
            be = Arrays.copyOfRange(be, 1, be.length);
        }
        byte[] out = new byte[len];
        int copy = Math.min(be.length, len);
        System.arraycopy(be, be.length - copy, out, len - copy, copy);
        int i = 0;
        for (int j = len - 1; i < j; ++i, --j) {
            byte t = out[i];
            out[i] = out[j];
            out[j] = t;
        }
        return out;
    }

    private static BigInteger leToInt(byte[] le) {
        byte[] be = Arrays.copyOf(le, le.length);
        int i = 0;
        for (int j = be.length - 1; i < j; ++i, --j) {
            byte t = be[i];
            be[i] = be[j];
            be[j] = t;
        }
        return new BigInteger(1, be);
    }

    private static BigInteger inv(BigInteger x) {
        return x.modInverse(P);
    }

    private static Point add(Point P1, Point P2) {
        BigInteger x1 = P1.x;
        BigInteger y1 = P1.y;
        BigInteger x2 = P2.x;
        BigInteger y2 = P2.y;
        BigInteger x1x2 = x1.multiply(x2).mod(P);
        BigInteger y1y2 = y1.multiply(y2).mod(P);
        BigInteger x1y2 = x1.multiply(y2).mod(P);
        BigInteger y1x2 = y1.multiply(x2).mod(P);
        BigInteger denX = BigInteger.ONE.add(D.multiply(x1x2).mod(P).multiply(y1y2).mod(P)).mod(P);
        BigInteger denY = BigInteger.ONE.subtract(D.multiply(x1x2).mod(P).multiply(y1y2).mod(P)).mod(P);
        BigInteger x3 = x1y2.add(y1x2).mod(P).multiply(Ed25519.inv(denX)).mod(P);
        BigInteger y3 = y1y2.add(x1x2).mod(P).multiply(Ed25519.inv(denY)).mod(P);
        return new Point(x3, y3);
    }

    private static Point dbl(Point P) {
        return Ed25519.add(P, P);
    }

    private static Point scalarMul(Point P, BigInteger k) {
        Point Q = ID;
        for (int i = k.bitLength() - 1; i >= 0; --i) {
            Q = Ed25519.dbl(Q);
            if (!k.testBit(i)) continue;
            Q = Ed25519.add(Q, P);
        }
        return Q;
    }

    private static Point scalarMulBase(BigInteger k) {
        return Ed25519.scalarMul(B, k);
    }

    private static byte[] encodePoint(Point P) {
        BigInteger y;
        BigInteger x = P.x;
        BigInteger yMasked = y = P.y;
        byte[] enc = Ed25519.intToLe(yMasked, 32);
        enc[31] = x.testBit(0) ? (byte)(enc[31] | 0x80) : (byte)(enc[31] & 0x7F);
        return enc;
    }

    private static Point decodePoint(byte[] enc) {
        BigInteger v;
        if (enc == null || enc.length != 32) {
            throw new IllegalArgumentException("point encoding must be 32 bytes");
        }
        byte[] yLe = Arrays.copyOf(enc, 32);
        int signX = (yLe[31] & 0x80) >>> 7;
        yLe[31] = (byte)(yLe[31] & 0x7F);
        BigInteger y = Ed25519.leToInt(yLe);
        BigInteger y2 = y.multiply(y).mod(P);
        BigInteger u = y2.subtract(BigInteger.ONE).mod(P);
        BigInteger x2 = u.multiply(Ed25519.inv(v = D.multiply(y2).add(BigInteger.ONE).mod(P))).mod(P);
        BigInteger x = x2.modPow(P.add(BigInteger.valueOf(3L)).shiftRight(3), P);
        if (!x.multiply(x).mod(P).equals(x2)) {
            x = x.multiply(SQRT_M1).mod(P);
        }
        if (!x.multiply(x).mod(P).equals(x2)) {
            throw new IllegalArgumentException("invalid point encoding");
        }
        if (x.testBit(0) != (signX == 1)) {
            x = P.subtract(x);
        }
        return new Point(x, y);
    }

    static {
        BX = new BigInteger("15112221349535400772501151409588531511454012693041857206046113283949847762202");
        BY = new BigInteger("46316835694926478169428394003475163141307993866256225615783033603165251855960");
        D = BigInteger.valueOf(-121665L).mod(P).multiply(BigInteger.valueOf(121666L).modInverse(P)).mod(P);
        SQRT_M1 = BigInteger.valueOf(2L).modPow(P.subtract(BigInteger.ONE).shiftRight(2), P);
        B = new Point(BX, BY);
        ID = new Point(BigInteger.ZERO, BigInteger.ONE);
    }

    public static final class KeyPair {
        private final byte[] seed32;
        private final byte[] public32;

        public KeyPair(byte[] seed32, byte[] public32) {
            this.seed32 = Arrays.copyOf(seed32, 32);
            this.public32 = Arrays.copyOf(public32, 32);
        }

        public byte[] getPrivateSeed() {
            return Arrays.copyOf(this.seed32, 32);
        }

        public byte[] getPublicKey() {
            return Arrays.copyOf(this.public32, 32);
        }
    }

    private static final class Digest {
        final byte[] bytes;

        Digest(byte[] b) {
            this.bytes = b;
        }
    }

    private static final class Point {
        final BigInteger x;
        final BigInteger y;

        Point(BigInteger x, BigInteger y) {
            this.x = x.mod(P);
            this.y = y.mod(P);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Point)) {
                return false;
            }
            Point p = (Point)o;
            return this.x.equals(p.x) && this.y.equals(p.y);
        }
    }
}

