/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.search.aggregations.BucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.SimpleRangeCollector;

public class SubAggRangeCollector
extends SimpleRangeCollector {
    private static final Logger logger = LogManager.getLogger(SubAggRangeCollector.class);
    private final Function<Integer, Long> getBucketOrd;
    private final BucketCollector collectableSubAggregators;
    private final LeafReaderContext leafCtx;
    private final FixedBitSet bitSet;
    private final BitDocIdSet bitDocIdSet;

    public SubAggRangeCollector(Ranges ranges, BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, int activeIndex, FilterRewriteOptimizationContext.OptimizeResult result, Function<Integer, Long> getBucketOrd, FilterRewriteOptimizationContext.SubAggCollectorParam subAggCollectorParam) {
        super(ranges, incrementRangeDocCount, maxNumNonZeroRange, activeIndex, result);
        this.getBucketOrd = getBucketOrd;
        this.collectableSubAggregators = subAggCollectorParam.collectableSubAggregators();
        this.leafCtx = subAggCollectorParam.leafCtx();
        int numDocs = this.leafCtx.reader().maxDoc();
        this.bitSet = new FixedBitSet(numDocs);
        this.bitDocIdSet = new BitDocIdSet((BitSet)this.bitSet);
    }

    @Override
    public boolean hasSubAgg() {
        return true;
    }

    @Override
    public void collectDocId(int docId) {
        this.bitSet.set(docId);
    }

    @Override
    public void collectDocIdSet(DocIdSetIterator iter) throws IOException {
        this.bitSet.or(iter);
    }

    @Override
    public void finalizePreviousRange() {
        super.finalizePreviousRange();
        long bucketOrd = this.getBucketOrd.apply(this.activeIndex);
        logger.trace("finalize range {} with bucket ordinal {}", (Object)this.activeIndex, (Object)bucketOrd);
        try {
            DocIdSetIterator iterator = this.bitDocIdSet.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(this.leafCtx);
            while (iterator.nextDoc() != Integer.MAX_VALUE) {
                int currentDoc = iterator.docID();
                sub.collect(currentDoc, bucketOrd);
            }
            logger.trace("collected sub aggregation for bucket {}", (Object)bucketOrd);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.bitSet.clear();
    }
}

