/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import jakarta.persistence.Parameter;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.ast.spi.SingleIdEntityLoader;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.QueryFlushMode;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.type.descriptor.java.JavaType;

public class SingleIdEntityLoaderProvidedQueryImpl<T>
implements SingleIdEntityLoader<T> {
    private final EntityMappingType entityDescriptor;
    private final NamedQueryMemento<T> namedQueryMemento;

    public SingleIdEntityLoaderProvidedQueryImpl(EntityMappingType entityDescriptor, NamedQueryMemento<T> namedQueryMemento) {
        this.entityDescriptor = entityDescriptor;
        this.namedQueryMemento = namedQueryMemento;
    }

    @Override
    public EntityMappingType getLoadable() {
        return this.entityDescriptor;
    }

    @Override
    public T load(Object pkValue, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        JavaType<?> mappedJavaType = this.entityDescriptor.getMappedJavaType();
        QueryImplementor<?> query = this.namedQueryMemento.toQuery(session, mappedJavaType.getJavaTypeClass());
        query.setParameter((Parameter)query.getParameters().iterator().next(), pkValue);
        query.setQueryFlushMode(QueryFlushMode.NO_FLUSH);
        return (T)query.uniqueResult();
    }

    @Override
    public T load(Object pkValue, Object entityInstance, LockOptions lockOptions, Boolean readOnly, SharedSessionContractImplementor session) {
        if (entityInstance != null) {
            throw new UnsupportedOperationException("null entity instance");
        }
        return this.load(pkValue, lockOptions, readOnly, session);
    }

    @Override
    public Object[] loadDatabaseSnapshot(Object id, SharedSessionContractImplementor session) {
        return ArrayHelper.EMPTY_OBJECT_ARRAY;
    }
}

