/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;

public class Distinct
implements Expression,
SqlExpressible,
SqlAstNode {
    private final Expression expression;

    public Distinct(Expression expression) {
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        Object object = this.expression;
        if (object instanceof SqlExpressible) {
            SqlExpressible sqlExpressible = (SqlExpressible)object;
            return sqlExpressible.getJdbcMapping();
        }
        object = this.getExpressionType();
        if (object instanceof SqlExpressible) {
            SqlExpressible sqlExpressible = (SqlExpressible)object;
            return sqlExpressible.getJdbcMapping();
        }
        if (this.getExpressionType() != null) {
            assert (this.getExpressionType().getJdbcTypeCount() == 1);
            return this.getExpressionType().getSingleJdbcMapping();
        }
        return null;
    }

    @Override
    public JdbcMappingContainer getExpressionType() {
        return this.expression.getExpressionType();
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitDistinct(this);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.getJdbcMapping());
        return this.getJdbcTypeCount();
    }
}

