/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.PathItem;

public class Paths
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.Paths>
implements org.eclipse.microprofile.openapi.models.Paths {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    public Map<String, PathItem> getPathItems() {
        return this.getProperties(PathItem.class);
    }

    public void setPathItems(Map<String, PathItem> newValue) {
        this.getPathItems().keySet().forEach(this::removePathItem);
        if (newValue != null) {
            newValue.forEach(this::addPathItem);
        }
    }

    public Paths addPathItem(String newKey, PathItem newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.setProperty(newKey, newValue);
        return this;
    }

    public void removePathItem(String key) {
        this.setProperty(key, null);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(1);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(1);

        public Properties() {
            this.types.put("io.smallrye.openapi.internal.model.unwrapped", DataType.type(PathItem.class));
            this.minVersions.put("PathItems", OpenApiVersion.V3_0);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            if (name.startsWith("x-")) {
                return DataType.type(Object.class);
            }
            return this.types.get("io.smallrye.openapi.internal.model.unwrapped");
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

