/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.common.util.Time;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.representations.JsonWebToken;

public abstract class AbstractJWTClientValidator {
    private static final Logger logger = Logger.getLogger(AbstractJWTClientValidator.class);
    protected final ClientAuthenticationFlowContext context;
    protected final RealmModel realm;
    protected final int currentTime;
    protected final SignatureValidator signatureValidator;
    protected final String clientAuthenticatorProviderId;
    protected String expectedClientAssertionType = "urn:ietf:params:oauth:client-assertion-type:jwt-bearer";
    protected final ClientAssertionState clientAssertionState;
    protected ClientModel client;

    public AbstractJWTClientValidator(ClientAuthenticationFlowContext context, SignatureValidator signatureValidator, String clientAuthenticatorProviderId) throws Exception {
        this.context = context;
        this.clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
        this.realm = context.getRealm();
        this.signatureValidator = signatureValidator;
        this.currentTime = Time.currentTime();
        this.clientAuthenticatorProviderId = clientAuthenticatorProviderId;
    }

    public ClientAuthenticationFlowContext getContext() {
        return this.context;
    }

    public ClientAssertionState getState() {
        return this.clientAssertionState;
    }

    public String getClientAssertion() {
        return this.clientAssertionState.getClientAssertion();
    }

    public JWSInput getJws() {
        return this.clientAssertionState.getJws();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public boolean validate() {
        return this.validateClientAssertionParameters() && this.validateClient() && this.validateSignatureAlgorithm() && this.validateSignature() && this.validateTokenAudience() && this.validateTokenActive();
    }

    private boolean validateClientAssertionParameters() {
        return this.expectedClientAssertionType.equals(this.clientAssertionState.getClientAssertionType()) && this.clientAssertionState.getClientAssertion() != null;
    }

    private boolean validateClient() {
        JsonWebToken token = this.clientAssertionState.getToken();
        String clientId = token.getSubject();
        if (clientId == null) {
            logger.debug((Object)"Can't identify client. Subject missing on JWT token");
            return this.failure("Token sub claim is required");
        }
        String clientIdParam = (String)this.context.getHttpRequest().getDecodedFormParameters().getFirst((Object)"client_id");
        if (clientIdParam != null && !clientIdParam.equals(clientId)) {
            logger.debug((Object)"client_id parameter does not match JWT subject");
            return this.failure("client_id parameter does not match sub claim");
        }
        String expectedTokenIssuer = this.getExpectedTokenIssuer();
        if (expectedTokenIssuer != null && !expectedTokenIssuer.equals(token.getIssuer())) {
            return false;
        }
        this.client = this.clientAssertionState.getClient();
        if (this.client == null) {
            return this.failure(AuthenticationFlowError.CLIENT_NOT_FOUND);
        }
        this.context.getEvent().client(this.client.getClientId());
        this.context.setClient(this.client);
        if (!this.client.isEnabled()) {
            return this.failure(AuthenticationFlowError.CLIENT_DISABLED);
        }
        if (this.clientAuthenticatorProviderId != null && !this.clientAuthenticatorProviderId.equals(this.client.getClientAuthenticatorType())) {
            logger.debug((Object)"Not configured authenticator for client, ignoring");
            return false;
        }
        return true;
    }

    private boolean validateSignatureAlgorithm() {
        JWSInput jws = this.clientAssertionState.getJws();
        if (jws.getHeader().getAlgorithm() == null) {
            return this.failure("Invalid signature algorithm");
        }
        String expectedSignatureAlg = this.getExpectedSignatureAlgorithm();
        if (expectedSignatureAlg != null && !expectedSignatureAlg.equals(jws.getHeader().getAlgorithm().name())) {
            return this.failure("Invalid signature algorithm");
        }
        return true;
    }

    private boolean validateSignature() {
        return this.signatureValidator.verifySignature(this);
    }

    public boolean validateTokenActive() {
        JsonWebToken token = this.clientAssertionState.getToken();
        int allowedClockSkew = this.getAllowedClockSkew();
        int maxExp = this.getMaximumExpirationTime();
        if (token.getExp() == null) {
            return this.failure("Token exp claim is required");
        }
        if (!token.isActive(allowedClockSkew)) {
            return this.failure("Token is not active");
        }
        long lifespan = token.getExp() - (long)this.currentTime;
        if (token.getIat() == null) {
            if (lifespan > (long)maxExp) {
                return this.failure("Token expiration is too far in the future and iat claim not present in token");
            }
        } else {
            if (token.getIat() - (long)allowedClockSkew > (long)this.currentTime) {
                return this.failure("Token was issued in the future");
            }
            if ((lifespan = Math.min(lifespan, (long)maxExp)) <= 0L) {
                return this.failure("Token is not active");
            }
            if ((long)this.currentTime > token.getIat() + (long)maxExp) {
                return this.failure("Token was issued too far in the past to be used now");
            }
        }
        if (!this.isReusePermitted()) {
            if (token.getId() == null) {
                return this.failure("Token jti claim is required");
            }
            if (!this.validateTokenReuse(token.getId(), lifespan)) {
                return false;
            }
        }
        return true;
    }

    private boolean validateTokenReuse(String tokenId, long lifespanInSecs) {
        SingleUseObjectProvider singleUseCache = this.context.getSession().singleUseObjects();
        if (!singleUseCache.putIfAbsent(tokenId, lifespanInSecs)) {
            logger.warnf("Token '%s' already used when authenticating client '%s'.", (Object)tokenId, (Object)this.client.getClientId());
            return this.failure("invalid_client", "Token reuse detected", Response.Status.BAD_REQUEST.getStatusCode());
        }
        logger.tracef("Added token '%s' to single-use cache. Lifespan: %d seconds, client: %s", (Object)tokenId, (Object)lifespanInSecs, (Object)this.client.getClientId());
        return true;
    }

    private boolean validateTokenAudience() {
        List<String> expectedAudiences;
        JsonWebToken token = this.clientAssertionState.getToken();
        if (!token.hasAnyAudience(expectedAudiences = this.getExpectedAudiences())) {
            return this.failure("Invalid token audience");
        }
        if (!this.isMultipleAudienceAllowed() && token.getAudience().length > 1) {
            return this.failure("Multiple audiences not allowed");
        }
        return true;
    }

    public boolean failure(String errorDescription) {
        return this.failure(errorDescription, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public boolean failure(String errorDescription, int statusCode) {
        return this.failure("invalid_client", errorDescription, statusCode);
    }

    public boolean failure(String error, String errorDescription, int statusCode) {
        Response challengeResponse = ClientAuthUtil.errorResponse(statusCode, error, errorDescription);
        return this.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
    }

    private boolean failure(AuthenticationFlowError error) {
        return this.failure(error, null);
    }

    private boolean failure(AuthenticationFlowError error, Response response) {
        this.context.failure(error, response);
        return false;
    }

    protected abstract String getExpectedTokenIssuer();

    protected abstract List<String> getExpectedAudiences();

    protected abstract boolean isMultipleAudienceAllowed();

    protected abstract int getAllowedClockSkew();

    protected abstract int getMaximumExpirationTime();

    protected abstract boolean isReusePermitted();

    protected abstract String getExpectedSignatureAlgorithm();

    public static interface SignatureValidator {
        public boolean verifySignature(AbstractJWTClientValidator var1);
    }
}

