/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerTestUtil;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class XTestContainer<T> {
    private List<T> myChildren;
    private CompletableFuture<Pair<List<T>, String>> myResultFuture;

    public XTestContainer() {
        this.reset();
    }

    protected void reset() {
        this.myChildren = new SmartList();
        this.myResultFuture = new CompletableFuture();
    }

    public void addChildren(List<? extends T> children, boolean last) {
        this.myChildren.addAll(children);
        if (last) {
            this.done(null);
        }
    }

    public void tooManyChildren(int remaining) {
        this.done(null);
    }

    private void done(@Nullable String errorMessage) {
        this.myResultFuture.complete(Pair.create(this.myChildren, (Object)errorMessage));
    }

    public void setMessage(@NotNull String message, Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (message == null) {
            XTestContainer.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            XTestContainer.$$$reportNull$$$0(1);
        }
    }

    public void setErrorMessage(@NotNull String message, @Nullable XDebuggerTreeNodeHyperlink link) {
        if (message == null) {
            XTestContainer.$$$reportNull$$$0(2);
        }
        this.setErrorMessage(message);
    }

    public void setErrorMessage(@NotNull String errorMessage) {
        if (errorMessage == null) {
            XTestContainer.$$$reportNull$$$0(3);
        }
        this.done(errorMessage);
    }

    @NotNull
    public Pair<List<T>, String> waitFor(long timeoutMs) {
        Pair<List<T>, String> result = XDebuggerTestUtil.waitFor(this.myResultFuture, timeoutMs);
        Assert.assertNotNull((String)"Timed out", result);
        Pair<List<T>, String> pair = result;
        if (pair == null) {
            XTestContainer.$$$reportNull$$$0(4);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/XTestContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/XTestContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "waitFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setErrorMessage";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

