/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.struct.StructTypePathEntry;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructTypeAnnotationAttribute
extends StructGeneralAttribute {
    private List<TypeAnnotation> annotations = Collections.emptyList();

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            this.annotations = new ArrayList<TypeAnnotation>(len);
            for (int i = 0; i < len; ++i) {
                this.annotations.add(StructTypeAnnotationAttribute.parse(data, pool));
            }
        } else {
            this.annotations = Collections.emptyList();
        }
    }

    private static TypeAnnotation parse(DataInputStream data, ConstantPool pool) throws IOException {
        int i;
        int targetType = data.readUnsignedByte();
        TargetInfo targetInfo = switch (targetType) {
            case 0, 1 -> new TargetInfo.TypeParameterTarget(data.readUnsignedByte());
            case 16 -> new TargetInfo.SupertypeTarget(data.readUnsignedShort());
            case 17, 18 -> new TargetInfo.TypeParameterBoundTarget(data.readUnsignedByte(), data.readUnsignedByte());
            case 19, 20, 21 -> new TargetInfo.EmptyTarget();
            case 22 -> new TargetInfo.FormalParameterTarget(data.readUnsignedByte());
            case 23 -> new TargetInfo.ThrowsTarget(data.readUnsignedShort());
            case 64, 65 -> {
                int tableLength = data.readUnsignedShort();
                TargetInfo.LocalvarTarget.Offsets[] offsets = new TargetInfo.LocalvarTarget.Offsets[tableLength];
                for (i = 0; i < tableLength; ++i) {
                    offsets[i] = new TargetInfo.LocalvarTarget.Offsets(data.readUnsignedShort(), data.readUnsignedShort(), data.readUnsignedShort());
                }
                yield new TargetInfo.LocalvarTarget(offsets);
            }
            case 66 -> new TargetInfo.CatchTarget(data.readUnsignedShort());
            case 67, 68, 69, 70 -> new TargetInfo.OffsetTarget(data.readUnsignedShort());
            case 71, 72, 73, 74, 75 -> new TargetInfo.TypeArgumentTarget(data.readUnsignedShort(), data.readUnsignedByte());
            default -> throw new RuntimeException("unknown target type: " + targetType);
        };
        int pathLength = data.readUnsignedByte();
        ArrayList<StructTypePathEntry> paths = new ArrayList<StructTypePathEntry>(pathLength);
        for (i = 0; i < pathLength; ++i) {
            paths.add(i, new StructTypePathEntry(data.readUnsignedByte(), data.readUnsignedByte()));
        }
        AnnotationExprent annotation = StructAnnotationAttribute.parseAnnotation(data, pool);
        return new TypeAnnotation(targetType, targetInfo, paths, annotation);
    }

    public List<TypeAnnotation> getAnnotations() {
        return this.annotations;
    }
}

