/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import one.util.streamex.StreamEx;

class AdverbAdjectiveConfusion {
    private static final NodePattern surelyAdverb = NodePattern.N.pos("RB|UH").andNot(NodePattern.N.potentialPos("JJ.*|VB.*")).andNot(EnglishTreePatterns.negation).noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound");
    static final NodePattern clauseAdjAdverb = surelyAdverb.form(".*ly").noForm("only|likely").andNot(CommonPatterns.firstChildPhrase.beforeHead().withHead("advmod", NodePattern.N.beforeHead().withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).andNot(NodePattern.N.form("nearly|barely|hardly").withHead("advmod", NodePattern.N.pos("NN.*")));
    private static final NodePattern probablyNonNoun = NodePattern.or(NodePattern.N.noPos("NN"), EnglishTreePatterns.unlikelyToBeNoun);
    static final NodePattern suggestAdjAnd = NodePattern.N.directlyBefore(probablyNonNoun.potentialPos("JJ").noPos("VB.*")).directlyAfter(NodePattern.not(NodePattern.N.lemma("not")));
    private static final NodePattern surelyAdj = NodePattern.N.potentialPos("JJ").noPotentialPos("IN|RB.*|VBG").noDependents("det|nmod:poss");
    static final NodePattern adjRequiringVerbs = NodePattern.N.lemma("remain|seem|become|smell|sound|taste|stay|prove|feel|look");
    static final NodePattern adjAllowingVerbs = NodePattern.N.lemma("make|come|grow|start|finish|test|get|label");
    private static final NodePattern nounPosition = NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").noHeadRelation("obl:tmod");
    private static final NodePattern allNoun = NodePattern.N.form("all").and(nounPosition);
    static final NodePattern fixClauseAdvToAdj = NodePattern.N.noForm("exactly|especially|wrinkly|husbandly|firstly|secondly|thirdly|fourthly").andNot(NodePattern.N.inFormSequence(0, "finally", "keywords?|blocks?")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.anchor(), match -> {
        Node node = match.anchor();
        return ((StreamEx)StreamEx.of(AdverbAdjectiveConfusion.advToAdj(node.form())).filter(adv -> node.tree().treeSupport().tagToken((String)adv).hasPos("JJ"))).toList();
    }));
    private static final NodePattern nonCopulaHead = NodePattern.N.withDependent("cop").anyPos().noPos("NN.*|JJ.*|RB.*|PRP.*|W.*|VB[NG]");

    AdverbAdjectiveConfusion() {
    }

    static NodePattern pattern() {
        return NodePattern.or(AdverbAdjectiveConfusion.wrongAdjective(), AdverbAdjectiveConfusion.wrongAdverb()).andNot(CommonPatterns.capitalizedMiddle).andNot(CommonPatterns.quotedWord).message("An adverb possibly confused with an adjective");
    }

    private static NodePattern wrongAdverb() {
        NodePattern advModifiable = NodePattern.N.pos("VB.*|NN.*|JJ.*");
        NodePattern allowAdverbWithLinkingVerb = NodePattern.or(NodePattern.N.form("indefinitely").withHead(NodePattern.N.lemma("remain")), NodePattern.N.form("strongly|badly").withHead(NodePattern.N.form("feel")).and(CommonPatterns.possiblySkipUp("advmod", NodePattern.N.withDependent("ccomp|advcl"))), NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.N.lemma("feel|stay|look").andOr(NodePattern.N.withDependent("obl"), NodePattern.markedNodeMatches("Adjective", NodePattern.N.form("well"))), NodePattern.N.form("looking").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", Semantics.Animacy.humanLike.pattern))));
        NodePattern copulaClause = NodePattern.N.withDependent("cop", NodePattern.not(NodePattern.N.directlyAfter(PunctuationRules.incompleteOptionalPluralParen))).noDependents("conj", NodePattern.N.pos("JJ.*").withDependent("advmod")).noDependents("advmod", NodePattern.N.form("so|only")).noDependents("nmod:poss").andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.inFormSequence(0, "than", "not"), NodePattern.N.form("@.+")))).andNot(NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|ccomp").withDependent("mark", NodePattern.or(NodePattern.N.form("than|as|whether"), NodePattern.N.pos("WRB"))).trace("elided copula head with adverb")).andNot(CommonPatterns.possiblySkipDown("dep", NodePattern.N.withDependent("punct", EnglishTreePatterns.aposOrQuote)));
        NodePattern nonAdvContext = NodePattern.N.markAs("Adverb").andOr(copulaClause.trace("copulaClause"), NodePattern.N.withHead("conj", copulaClause.markAs("HeadCopula")).withDependent("cc", NodePattern.not(NodePattern.N.inFormSequence(1, ",", "but"))).trace("copulaClause conj"), NodePattern.N.withHead("conj", surelyAdj.withHeadRelation("amod").andNot(NodePattern.custom(n -> AdverbAdjectiveConfusion.wrongAdjective().matches((Node)n))).noDependents("obl", NodePattern.N.after("Adverb"))).andNot(NodePattern.N.form("preferably").directlyBefore(NodePattern.N.withHeadRelation("case"))), NodePattern.N.inFormSequence(2, "the", "more|less", "probably"), NodePattern.N.form("normally").withHead("advmod", NodePattern.N.pos("NN.*").andNot(NodePattern.N.pos("JJ.*|RB.*")).withDependent("cop", NodePattern.N.before("Adverb")).withDependent("case", NodePattern.N.after("Adverb"))).directlyAfter(NodePattern.N.withHeadRelation("advmod").noForm("very|also")), CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.beforeHead().withHead("amod", NodePattern.N.pos("NN.*").noMatchUntil("Adverb", NodePattern.or(advModifiable, EnglishTreePatterns.quotations)).noHeadRelation("obl:npmod").andNot(NodePattern.N.withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.form("/"))))).andNot(CommonPatterns.firstChildPhrase.withHead(NodePattern.N.withHeadRelation("nsubj.*").beforeHead())).trace("adverb as amod before head"), NodePattern.N.withHead(NodePattern.N.markAs("Head")).and(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter("Head"))).withHead("advmod|xcomp", adjRequiringVerbs.noDependents("xcomp|obj", NodePattern.N.after("Adverb")).noDependents("mark|advmod", NodePattern.N.form("how")).andNot(NodePattern.N.withHead("advcl:relcl", NodePattern.N.form("how")))).andNot(allowAdverbWithLinkingVerb).andNot(NodePattern.N.withNextSibling(NodePattern.N.anyMatchUntil("Adverb", NodePattern.PUNCT))).noForm("well").trace("adverb with adj requiring head"), NodePattern.N.withHead("advmod", NodePattern.N.pos("VB").withDependent("mark", NodePattern.N.form("to").after("Adverb")).withDependent("nsubj", NodePattern.N.before("Adverb")).noHeadRelation("ccomp|root")).trace("advmod with base verb head"), NodePattern.N.withHead("advmod", NodePattern.N.lemma("be").before("Adverb").markAs("Verb").noDependents("xcomp|advcl").noDependents("advmod|expl", NodePattern.N.after("Adverb")).noDependents("ccomp", NodePattern.or(NodePattern.N.withDependent(".*", Questions.whPhrase), NodePattern.N.withDependent("mark", NodePattern.N.form("to")))).noDependents("mark", NodePattern.N.form("than|as|like")).noDependents("nsubj", NodePattern.N.after("Verb")).andNot(NodePattern.N.withHead("a(dv)?cl:relcl", NodePattern.or(Questions.whWord, NodePattern.N.form("ones?"))))).andNot(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("that"))).trace("advmod with be as head"), NodePattern.N.withHead("advmod", NodePattern.N.pos("NN.*").noPos("PRP").noPotentialPos("VBN|JJ.*").andNot(EnglishTreePatterns.someAnyEveryNoX).andOr(nounPosition.directlyAfter("Adverb").andNot(allNoun).noHeadRelation("compound").noDependents("case", NodePattern.N.directlyBefore(NodePattern.N.form("essentially|basically").alreadyMarkedAs("Adverb")).trace("with [what are] essentially placeholders")).andNot(NodePattern.N.label(".*")).andNot(NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion").directlyBefore(NodePattern.N.form("of"))), NodePattern.N.after("Adverb").withDependent("det", NodePattern.N.before("Adverb")).andNot(CommonPatterns.severalDependents("det"))).noForm("small")).noForm("mostly").trace("advmod modifying a noun")))).andNot(NodePattern.N.withHead("conj", NodePattern.N.beforeHead().withHeadRelation("amod").withNextSibling(NodePattern.N.withHeadRelation("amod").potentialPos("VBN"))).trace("misattached adverb (Recent/Recently Edited Files)")).andNot(Commas.adverbsToFrontWithComma).andNot(CommonPatterns.firstWord.directlyBefore(CommonPatterns.comma)).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("no|without|than"))).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)).andNot(NodePattern.N.directlyAfter(CommonPatterns.comma)).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("CD"))).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.kinda.directlyBefore(NodePattern.N.form("of")))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.lemma("look")).withDependent("advmod", NodePattern.N.form("more"))).andNot(NodePattern.N.withHead("advmod", nounPosition).directlyBefore(NodePattern.N.withHeadRelation("case"))).andNot(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("advcl")).directlyBefore(NodePattern.N.withHeadRelation("mark")));
        return NodePattern.or(clauseAdjAdverb.and(nonAdvContext).and(fixClauseAdvToAdj), NodePattern.N.form("often").and(nonAdvContext).noDependents("advcl|csubj", EnglishTreePatterns.withThatMark).andNot(NodePattern.N.withHeadRelation("acl:relcl|ccomp").withDependent("nsubj", NodePattern.N.form("which"))).correct(NodeCorrector.replace("frequent")), NodePattern.N.form("mostly").withHead("advmod", NodePattern.N.pos("VBN").withDependent("cop").noDependents("obl")).correct(NodeCorrector.replace("most")), NodePattern.N.form("well").and(nonAdvContext).withHead(adjRequiringVerbs.withDependent(".*", NodePattern.N.after("Adverb")).noDependents("conj")).correct(NodeCorrector.replace("good")));
    }

    private static NodePattern wrongAdjective() {
        NodePattern definitelyVerbalClause = EnglishTreePatterns.verbalClause.noPos("NN.*").andNot(NodePattern.ROOT.form("select")).noDependents("compound|nummod|nmod.*").andNot(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("acl")).potentialPos("VBN").and(EnglishTreePatterns.withoutSubject).trace("wide eyed")).andNot(CommonPatterns.beforeParenth).andNot(nonCopulaHead).andNot(EnglishTreePatterns.vbAposS).noHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound");
        NodePattern advRequiresParticipleHead = NodePattern.N.form("fresh|new");
        NodePattern advRequiresAdjectiveHead = NodePattern.N.form("human");
        NodePattern midparsedAdvcl = NodePattern.N.withDependent(".*").withNextSibling(CommonPatterns.comma.beforeHead());
        NodePattern possiblyPostfixAcl = NodePattern.N.directlyBeforeHead().withHead("advmod", NodePattern.N.pos("VBN").withDependent("cop|aux:pass", NodePattern.N.lemma("be")));
        return surelyAdj.markAs("Adjective").noForm("else|very|first|second|third|prior|front|big|several|old|contrary|flat|dead|long|deep|on|even|great|low|able").noForm(".*-.*|.*th").noLabel(".*").andNot(advRequiresParticipleHead.andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VBN")))).andNot(advRequiresAdjectiveHead.withHead(NodePattern.N.noPos("JJ[RS]?"))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("-|born|of"), EnglishTreePatterns.quotations))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("oh"))).andNot(NodePattern.N.inFormSequence(0, "safe", "delete")).andNot(NodePattern.N.inFormSequence(0, "dynamic", "tables?")).andNot(NodePattern.N.inFormSequence(1, "in", "general")).andNot(NodePattern.N.inFormSequence(0, "sound", "asleep")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("-|once"))).andNot(NodePattern.N.form("reverse|double").withHead("advmod", NodePattern.N.potentialPos("VBN?"))).andNot(NodePattern.N.withNextSibling(EnglishTreePatterns.compound.withDependent("det|compound", NodePattern.N.pos("DT")))).andNot(NodePattern.N.withHead(NodePattern.N.inFormSequence(0, "braces?", "syntax"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.comma).beforeHead().withHead(NodePattern.N.pos("VB[GN]"))).noDependents("advcl").andNot(NodePattern.N.form("high").withHeadRelation("advmod").afterHead()).andNot(NodePattern.N.form("absent").withDependent("obl")).and(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.beforeHead().withHead("advmod", probablyNonNoun.andOr(NodePattern.N.withDependent("cop").noDependents("aux", NodePattern.N.lemma("be")), NodePattern.N.pos("JJ").withHeadRelation("xcomp"))).trace("advmod before head"), NodePattern.N.withHead("advmod", NodePattern.or(definitelyVerbalClause, NodePattern.N.pos("VBG").withHead("xcomp", definitelyVerbalClause)).noDependents("cop")).andOr(NodePattern.N.beforeHead().withHead(NodePattern.not(NodePattern.ROOT.pos("VB").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").noDependents(Questions.whPhrase))).andNot(midparsedAdvcl).andNot(NodePattern.N.withNextSibling(midparsedAdvcl.withHeadRelation("advmod"))), NodePattern.N.afterHead().directlyAfter(NodePattern.N.withHeadRelation("advmod")).noPos("VBN").withHead(NodePattern.not(adjRequiringVerbs).andNot(adjAllowingVerbs).andNot(NodePattern.N.lemma("go").noDependents(NodePattern.N.afterHead().before("Adjective")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("more")).withDependent("conj", NodePattern.N.pos("JJ")))).andNot(NodePattern.N.withDependent("punct", NodePattern.N.beforeHead()).and(NodePattern.N.withHead("advmod", NodePattern.N.withDependent("obj").afterHead())).trace("possibly misattached advmod")).trace("advmod on definitelyVerbalClause"), NodePattern.N.withHead("xcomp", NodePattern.N.pos("VBG").withOnlyDependents(NodePattern.N.alreadyMarkedAs("Adjective")).withHead("xcomp", definitelyVerbalClause).directlyAfterHead().andNot(NodePattern.or(adjRequiringVerbs, adjAllowingVerbs))).noDependents(NodePattern.N.afterHead()).trace("double xcomp on definitelyVerbalClause"), NodePattern.N.beforeHead().withHead("amod", NodePattern.or(definitelyVerbalClause, allNoun).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.withHead("conj", NodePattern.N.pos("NN.*"))).noDependents("list")).trace("amod before verbal head"), NodePattern.N.afterHead().withHeadRelation("xcomp|advmod").noDependents().withHead(NodePattern.or(NodePattern.N.lemma("work|learn"), NodePattern.N.lemma("end").noDependents("compound:prt"), NodePattern.N.lemma("play").withDependent("obj", NodePattern.N.noForm("it")), NodePattern.N.lemma("spend").withDependent("advcl", NodePattern.N.directlyAfter("Adjective")), NodePattern.N.noLemma("go").directlyAfterHead().directlyBefore("Adjective").pos("VBG").withHeadRelation("acl").andNot(adjAllowingVerbs).andNot(adjRequiringVerbs).andNot(NodePattern.markedNodeMatches("Adjective", NodePattern.N.pos("VBN"))))).trace("lone xcomp|advmod after head"), NodePattern.N.afterHead().withHead("amod", NodePattern.N.withHeadRelation("nsubj.*").beforeHead().markAs("Subj").andNot(EnglishTreePatterns.someAnyEveryNoX)).noDependents().andOr(NodePattern.markedNodeMatches("Subj", NodePattern.N.pos("PRP")), NodePattern.N.form("real")).trace("post-head subject amod"), NodePattern.N.withHead("advmod", allNoun).trace("all advmod"), NodePattern.N.noPos("NN.*").andNot(EnglishTreePatterns.clause).directlyAfter(NodePattern.N.noPos("RB.*")).withHead("conj", surelyAdverb.andNot(EnglishTreePatterns.clause).andNot(NodePattern.custom(n -> AdverbAdjectiveConfusion.wrongAdverb().matches((Node)n)))).trace("conj on adverb"), NodePattern.N.directlyBefore(NodePattern.N.form("every")).andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withHead("nmod", EnglishTreePatterns.nmodWithoutCase)).trace("amod/nmod before every"), NodePattern.N.noPotentialPos("V.*").withDependent("xcomp", NodePattern.N.directlyAfter("Adjective").pos("VBP?").noPos("JJ.*").andNot(CommonPatterns.capitalizedMiddle).andNot(WordSeparation.doItYourself)).trace("non-verb with base verb xcomp"), NodePattern.N.directlyBeforeHead().withHead("dep", NodePattern.N.withHeadRelation("xcomp").pos("VBP?").noPos("JJ.*")).trace("dep before base verb xcomp"), EnglishTreePatterns.possibleDoubleXComp, NodePattern.N.withDependent("cop").withDependent("advmod", NodePattern.N.directlyAfterHead().potentialPos("JJ").andOr(NodePattern.N.noPos("RB.*").noDependents("advmod").andNot(NodePattern.N.inFormSequence(0, "free", "of", "charge")).andNot(NodePattern.N.inFormSequence(0, "relative", "to")), NodePattern.N.form("down|up").andNot(NodePattern.N.inFormSequence(0, "up", "until")))).trace("with cop and directly before adverb"), NodePattern.N.form("real").directlyBefore(NodePattern.N.form("nice|good|bad").withHeadRelation("amod")).trace("real before nice|good|bad"), NodePattern.N.form("common|initial|frequent").directlyBefore(NodePattern.N.directlyBeforeHead().withHead("amod", NodePattern.not(NodePattern.N.form("testing"))).potentialPos("VBN").noForm("uncovered|mixed")).trace("common|initial|frequent before adverb"), advRequiresParticipleHead.withHeadRelation("advmod|amod").beforeHead().directlyBefore(NodePattern.or(NodePattern.N.lemma("elect|select|appoint|create|form|establish|build|develop|renovate|construct|design|publish|release|launch"), NodePattern.N.form("trained|married|washed")).andOr(NodePattern.N.withHeadRelation("amod"), CommonPatterns.skipConjUp(NodePattern.N.pos("JJ"))).noDependents(NodePattern.N.afterHead())).trace("advRequiresParticipleHead")))).andNot(NodePattern.N.withHead("conj", NodePattern.not(surelyAdverb))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("how"))).andNot(NodePattern.N.form("dry").withHead("advmod", NodePattern.N.lemma("clean"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("enough"))).andNot(NodePattern.N.withHead(NodePattern.N.anyMatchUntil("Adjective", NodePattern.N.form("[:;]")))).andNot(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.openingParen)).and((node, match) -> {
            List<String> nouns;
            if (node.hasForm("free")) {
                match = match.withCorrector(NodeCorrector.replace(node, "for free"));
            }
            String adv = AdverbAdjectiveConfusion.adjToAdv(node.form());
            if (!node.tree().treeSupport().tagToken(adv).hasPos("RB")) {
                return null;
            }
            match = match.withCorrector(NodeCorrector.replace(node, adv));
            if (suggestAdjAnd.matches(node)) {
                match = match.withCorrector(NodeCorrector.insertAfter(node, " and"));
            }
            if (possiblyPostfixAcl.matches(node) && (nouns = Articles.adjsToNouns.get(node.lowForm())) != null) {
                match = match.withCorrector(NodeCorrector.replace(node, nouns));
            }
            return match;
        });
    }

    static String adjToAdv(String adj) {
        if (adj.equals("simple")) {
            return "simply";
        }
        if (adj.equals("full")) {
            return "fully";
        }
        if (adj.equals("good")) {
            return "well";
        }
        if (adj.endsWith("y")) {
            return adj.substring(0, adj.length() - 1) + "ily";
        }
        if (adj.endsWith("ic")) {
            return adj + "ally";
        }
        if (adj.endsWith("ble")) {
            return adj.substring(0, adj.length() - 1) + "y";
        }
        return adj + "ly";
    }

    private static List<String> advToAdj(String adv) {
        if (adv.equals("dramatically")) {
            return List.of("dramatic");
        }
        if (adv.equals("simply")) {
            return List.of("simple");
        }
        if (adv.equals("fully")) {
            return List.of("full");
        }
        if (adv.endsWith("ily")) {
            return List.of(adv.substring(0, adv.length() - 3) + "y");
        }
        if (adv.endsWith("bly")) {
            return List.of(adv.substring(0, adv.length() - 1) + "e");
        }
        if (adv.endsWith("ically")) {
            return List.of(adv.substring(0, adv.length() - 4), adv.substring(0, adv.length() - 2));
        }
        if (adv.endsWith("ly")) {
            return List.of(adv.substring(0, adv.length() - 2));
        }
        return List.of();
    }
}

