/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.ide.fileTemplates.actions.CustomCreateFromTemplateAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.plugins.javaFX.actions.JavaFxTemplateManager;

final class CreateFxmlFileAction
extends CustomCreateFromTemplateAction
implements DumbAware {
    private static final String INTERNAL_TEMPLATE_NAME = "FxmlFile.fxml";

    CreateFxmlFileAction() {
        super(INTERNAL_TEMPLATE_NAME);
    }

    protected Map<String, String> getLiveTemplateDefaults(@NotNull DataContext dataContext, @NotNull PsiFile file) {
        if (dataContext == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(1);
        }
        String packageName = (String)ReadAction.compute(() -> {
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory != null) {
                VirtualFile vDirectory = psiDirectory.getVirtualFile();
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
                if (index.isInSourceContent(vDirectory)) {
                    return PackageIndex.getInstance((Project)file.getProject()).getPackageNameByDirectory(vDirectory);
                }
            }
            return null;
        });
        @NonNls String name = file.getName();
        if ("fxml".equals(PathUtil.getFileExtension((String)(name = PathUtil.getFileName((String)name))))) {
            name = name.substring(0, name.length() - "fxml".length() - 1);
        }
        name = CreateFxmlFileAction.toClassName(name);
        name = !StringUtil.isEmpty((String)packageName) ? packageName + "." + name : name;
        return Collections.singletonMap("CONTROLLER_NAME", name);
    }

    private static String toClassName(String name) {
        char c;
        for (int start = 0; !(start >= name.length() || Character.isJavaIdentifierStart(c = name.charAt(start)) && c != '_' && c != '$'); ++start) {
        }
        StringBuilder className = new StringBuilder();
        boolean skip = true;
        for (int i = start; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c2) || c2 == '_' || c2 == '$') {
                skip = true;
                continue;
            }
            if (skip) {
                skip = false;
                className.append(Character.toUpperCase(c2));
                continue;
            }
            className.append(c2);
        }
        return className.toString();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(JavaFxTemplateManager.isJavaFxTemplateAvailable(e.getDataContext(), JavaModuleSourceRootTypes.PRODUCTION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/actions/CreateFxmlFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiveTemplateDefaults";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

