---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Frame.io API token'
---

## Description

The response body contains content that matches the pattern of a Frame.io API token was identified. Frame.io supports external access through scoped API tokens. Tokens are associated with individual user accounts, and have the same access permissions as the user who created them. All API actions in Frame.io are restricted by scopes. A malicious actor with access to this token can execute various functionality depending on scopes assigned to the token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To revoke the API token:

- Sign in and access <https://developer.frame.io/app/tokens>
- Find the token that was identified and take note of the scopes assigned to it
- Select the trash icon to the right of the identified token
- When prompted with "Delete token?" select "Delete"

For more information, please see [Frame.io's documentation on authentication](https://developer.frame.io/docs/getting-started/authentication).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.48 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
