/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ant.jmx;

import java.io.IOException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JMXAccessorTask
extends BaseRedirectorHelperTask {
    public static final String JMX_SERVICE_PREFIX = "service:jmx:rmi:///jndi/rmi://";
    public static final String JMX_SERVICE_SUFFIX = "/jmxrmi";
    private String name = null;
    private String resultproperty;
    private String url = null;
    private String host = "localhost";
    private String port = "8050";
    private String password = null;
    private String username = null;
    private String ref = "jmx.server";
    private boolean echo = false;
    private boolean separatearrayresults = true;
    private String delimiter;
    private String unlessCondition;
    private String ifCondition;
    private final Properties properties = new Properties();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getResultproperty() {
        return this.resultproperty;
    }

    public void setResultproperty(String string) {
        this.resultproperty = string;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String string) {
        this.delimiter = string;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean bl) {
        this.echo = bl;
    }

    public boolean isSeparatearrayresults() {
        return this.separatearrayresults;
    }

    public void setSeparatearrayresults(boolean bl) {
        this.separatearrayresults = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public boolean isUseRef() {
        return this.ref != null && !this.ref.isEmpty();
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String string) {
        this.ref = string;
    }

    public String getIf() {
        return this.ifCondition;
    }

    public void setIf(String string) {
        this.ifCondition = string;
    }

    public String getUnless() {
        return this.unlessCondition;
    }

    public void setUnless(String string) {
        this.unlessCondition = string;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            try {
                MBeanServerConnection mBeanServerConnection = this.getJMXConnection();
                String string = this.jmxExecute(mBeanServerConnection);
                if (string != null && this.isFailOnError()) {
                    throw new BuildException(string);
                }
            }
            catch (Exception exception) {
                if (this.isFailOnError()) {
                    throw new BuildException((Throwable)exception);
                }
                this.handleErrorOutput(exception.getMessage());
            }
            finally {
                this.closeRedirector();
            }
        }
    }

    public static MBeanServerConnection createJMXConnection(String string, String string2, String string3, String string4, String string5) throws MalformedURLException, IOException {
        Object object = string != null ? string : JMX_SERVICE_PREFIX + string2 + ":" + string3 + JMX_SERVICE_SUFFIX;
        HashMap<String, String[]> hashMap = null;
        if (string4 != null && string5 != null) {
            String[] stringArray = new String[]{string4, string5};
            hashMap = new HashMap<String, String[]>();
            hashMap.put("jmx.remote.credentials", stringArray);
        }
        return JMXConnectorFactory.connect(new JMXServiceURL((String)object), hashMap).getMBeanServerConnection();
    }

    protected boolean testIfCondition() {
        if (this.ifCondition == null || this.ifCondition.isEmpty()) {
            return true;
        }
        return this.getProperty(this.ifCondition) != null;
    }

    protected boolean testUnlessCondition() {
        if (this.unlessCondition == null || this.unlessCondition.isEmpty()) {
            return true;
        }
        return this.getProperty(this.unlessCondition) == null;
    }

    public static MBeanServerConnection accessJMXConnection(Project project, String string, String string2, String string3, String string4, String string5, String string6) throws MalformedURLException, IOException {
        boolean bl;
        MBeanServerConnection mBeanServerConnection = null;
        boolean bl2 = bl = project != null && string6 != null && !string6.isEmpty();
        if (bl) {
            Object object = project.getReference(string6);
            try {
                mBeanServerConnection = (MBeanServerConnection)object;
            }
            catch (ClassCastException classCastException) {
                project.log("wrong object reference " + string6 + " - " + String.valueOf(object.getClass()));
                return null;
            }
        }
        if (mBeanServerConnection == null) {
            mBeanServerConnection = JMXAccessorTask.createJMXConnection(string, string2, string3, string4, string5);
        }
        if (bl && mBeanServerConnection != null) {
            project.addReference(string6, (Object)mBeanServerConnection);
        }
        return mBeanServerConnection;
    }

    protected MBeanServerConnection getJMXConnection() throws MalformedURLException, IOException {
        MBeanServerConnection mBeanServerConnection = null;
        if (this.isUseRef()) {
            Object object;
            if (this.getProject() != null && (object = this.getProject().getReference(this.getRef())) != null) {
                try {
                    mBeanServerConnection = (MBeanServerConnection)object;
                }
                catch (ClassCastException classCastException) {
                    this.getProject().log("Wrong object reference " + this.getRef() + " - " + String.valueOf(object.getClass()));
                    return null;
                }
            }
            if (mBeanServerConnection == null) {
                mBeanServerConnection = JMXAccessorTask.accessJMXConnection(this.getProject(), this.getUrl(), this.getHost(), this.getPort(), this.getUsername(), this.getPassword(), this.getRef());
            }
        } else {
            mBeanServerConnection = JMXAccessorTask.accessJMXConnection(this.getProject(), this.getUrl(), this.getHost(), this.getPort(), this.getUsername(), this.getPassword(), null);
        }
        return mBeanServerConnection;
    }

    public String jmxExecute(MBeanServerConnection mBeanServerConnection) throws Exception {
        if (mBeanServerConnection == null) {
            throw new BuildException("Must open a connection!");
        }
        if (this.isEcho()) {
            this.handleOutput("JMX Connection ref=" + this.ref + " is open!");
        }
        return null;
    }

    protected Object convertStringToType(String string, String string2) {
        Object object;
        block26: {
            if ("java.lang.String".equals(string2)) {
                return string;
            }
            object = string;
            if ("java.lang.Integer".equals(string2) || "int".equals(string2)) {
                try {
                    object = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.isEcho()) {
                        this.handleErrorOutput("Unable to convert to integer:" + string);
                    }
                    break block26;
                }
            }
            if ("java.lang.Long".equals(string2) || "long".equals(string2)) {
                try {
                    object = Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.isEcho()) {
                        this.handleErrorOutput("Unable to convert to long:" + string);
                    }
                    break block26;
                }
            }
            if ("java.lang.Boolean".equals(string2) || "boolean".equals(string2)) {
                object = Boolean.valueOf(string);
            } else {
                if ("java.lang.Float".equals(string2) || "float".equals(string2)) {
                    try {
                        object = Float.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.isEcho()) {
                            this.handleErrorOutput("Unable to convert to float:" + string);
                        }
                        break block26;
                    }
                }
                if ("java.lang.Double".equals(string2) || "double".equals(string2)) {
                    try {
                        object = Double.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (this.isEcho()) {
                            this.handleErrorOutput("Unable to convert to double:" + string);
                        }
                        break block26;
                    }
                }
                if ("javax.management.ObjectName".equals(string2) || "name".equals(string2)) {
                    try {
                        object = new ObjectName(string);
                    }
                    catch (MalformedObjectNameException malformedObjectNameException) {
                        if (this.isEcho()) {
                            this.handleErrorOutput("Unable to convert to ObjectName:" + string);
                        }
                        break block26;
                    }
                }
                if ("java.net.InetAddress".equals(string2)) {
                    try {
                        object = InetAddress.getByName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        if (!this.isEcho()) break block26;
                        this.handleErrorOutput("Unable to resolve host name:" + string);
                    }
                }
            }
        }
        return object;
    }

    protected void echoResult(String string, Object object) {
        if (this.isEcho()) {
            if (object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    this.handleOutput(string + "." + i + "=" + String.valueOf(Array.get(object, i)));
                }
            } else {
                this.handleOutput(string + "=" + String.valueOf(object));
            }
        }
    }

    protected void createProperty(Object object) {
        if (this.resultproperty != null) {
            this.createProperty(this.resultproperty, object);
        }
    }

    protected void createProperty(String string, Object object) {
        if (string == null) {
            string = "";
        }
        if (object instanceof CompositeDataSupport) {
            CompositeDataSupport compositeDataSupport = (CompositeDataSupport)object;
            CompositeType compositeType = compositeDataSupport.getCompositeType();
            Set<String> set = compositeType.keySet();
            for (String string2 : set) {
                Object object2 = compositeDataSupport.get(string2);
                OpenType<?> openType = compositeType.getType(string2);
                if (openType instanceof SimpleType) {
                    this.setProperty(string + "." + string2, object2);
                    continue;
                }
                this.createProperty(string + "." + string2, object2);
            }
        } else if (object instanceof TabularDataSupport) {
            TabularDataSupport tabularDataSupport = (TabularDataSupport)object;
            for (Object object3 : tabularDataSupport.keySet()) {
                for (Object e : (List)object3) {
                    CompositeData compositeData = tabularDataSupport.get(new Object[]{e});
                    Object object4 = compositeData.get("value");
                    OpenType<?> openType = compositeData.getCompositeType().getType("value");
                    if (openType instanceof SimpleType) {
                        this.setProperty(string + "." + String.valueOf(e), object4);
                        continue;
                    }
                    this.createProperty(string + "." + String.valueOf(e), object4);
                }
            }
        } else if (object.getClass().isArray()) {
            if (this.isSeparatearrayresults()) {
                int n = 0;
                for (int i = 0; i < Array.getLength(object); ++i) {
                    if (!this.setProperty(string + "." + n, Array.get(object, i))) continue;
                    ++n;
                }
                if (n > 0) {
                    this.setProperty(string + ".Length", Integer.toString(n));
                }
            }
        } else {
            String string3 = this.getDelimiter();
            if (string3 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(object.toString(), string3);
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    if (!this.setProperty(string + "." + n, string4)) continue;
                    ++n;
                }
                if (n > 0) {
                    this.setProperty(string + ".Length", Integer.toString(n));
                }
            } else {
                this.setProperty(string, object.toString());
            }
        }
    }

    public String getProperty(String string) {
        Project project = this.getProject();
        if (project != null) {
            return project.getProperty(string);
        }
        return this.properties.getProperty(string);
    }

    public boolean setProperty(String string, Object object) {
        if (string != null) {
            Project project;
            if (object == null) {
                object = "";
            }
            if (this.isEcho()) {
                this.handleOutput(string + "=" + object.toString());
            }
            if ((project = this.getProject()) != null) {
                project.setNewProperty(string, object.toString());
            } else {
                this.properties.setProperty(string, object.toString());
            }
            return true;
        }
        return false;
    }
}

