/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jaybird.xca;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.firebirdsql.gds.JaybirdSystemProperties;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSServerVersion;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.IConnectionProperties;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DatabaseListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.StatementListener;
import org.firebirdsql.jaybird.xca.FBConnectionRequestInfo;
import org.firebirdsql.jaybird.xca.FBIncorrectXidException;
import org.firebirdsql.jaybird.xca.FBLocalTransaction;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jaybird.xca.FBTpb;
import org.firebirdsql.jaybird.xca.FBXAException;
import org.firebirdsql.jaybird.xca.FBXid;
import org.firebirdsql.jaybird.xca.FatalErrorHelper;
import org.firebirdsql.jaybird.xca.XcaConnectionEvent;
import org.firebirdsql.jaybird.xca.XcaConnectionEventListener;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBTpbMapper;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.ByteArrayHelper;

public final class FBManagedConnection
implements ExceptionListener {
    public static final String ERROR_NO_CHARSET = "Connection rejected: No connection character set specified (property lc_ctype, encoding, charSet or localEncoding). Please specify a connection character set (eg property charSet=utf-8) or consult the Jaybird documentation for more information.";
    private static final Logger log = LoggerFactory.getLogger(FBManagedConnection.class);
    private final FBManagedConnectionFactory mcf;
    private final List<XcaConnectionEventListener> connectionEventListeners = new CopyOnWriteArrayList<XcaConnectionEventListener>();
    private static final AtomicReferenceFieldUpdater<FBManagedConnection, FBConnection> connectionHandleUpdater = AtomicReferenceFieldUpdater.newUpdater(FBManagedConnection.class, FBConnection.class, "connectionHandle");
    private volatile FBConnection connectionHandle;
    private static final AtomicReferenceFieldUpdater<FBManagedConnection, SQLWarning> unnotifiedWarningsUpdater = AtomicReferenceFieldUpdater.newUpdater(FBManagedConnection.class, SQLWarning.class, "unnotifiedWarnings");
    private volatile SQLWarning unnotifiedWarnings;
    private int timeout = 0;
    private final Map<Xid, FbTransaction> xidMap = new ConcurrentHashMap<Xid, FbTransaction>();
    private GDSHelper gdsHelper;
    private final FbDatabase database;
    private XAResource xaResource;
    private final FBConnectionRequestInfo cri;
    private FBTpbMapper transactionMapping;
    private FBTpb tpb;
    private int transactionIsolation;
    private volatile boolean managedEnvironment = true;
    private final Set<Xid> preparedXid = Collections.synchronizedSet(new HashSet());
    private volatile boolean inDistributedTransaction = false;
    private static final Set<TransactionState> XID_ACTIVE_STATE = Collections.unmodifiableSet(EnumSet.of(TransactionState.ACTIVE, TransactionState.PREPARED, TransactionState.PREPARING));
    static final CELNotifier connectionClosedNotifier = XcaConnectionEventListener::connectionClosed;
    static final CELNotifier connectionErrorOccurredNotifier = XcaConnectionEventListener::connectionErrorOccurred;

    FBManagedConnection(FBConnectionRequestInfo cri, FBManagedConnectionFactory mcf) throws SQLException {
        this.mcf = mcf;
        this.cri = this.getCombinedConnectionRequestInfo(cri);
        this.tpb = mcf.getDefaultTpb();
        this.transactionIsolation = mcf.getDefaultTransactionIsolation();
        IConnectionProperties connectionProperties = this.cri.asIConnectionProperties();
        if (connectionProperties.getEncoding() == null && connectionProperties.getCharSet() == null) {
            String defaultEncoding = FBManagedConnection.getDefaultConnectionEncoding();
            if (defaultEncoding == null) {
                throw new SQLNonTransientConnectionException(ERROR_NO_CHARSET, "08000");
            }
            connectionProperties.setEncoding(defaultEncoding);
        }
        if (connectionProperties.getConnectTimeout() == -1 && DriverManager.getLoginTimeout() > 0) {
            connectionProperties.setConnectTimeout(DriverManager.getLoginTimeout());
        }
        this.database = mcf.getDatabaseFactory().connect(connectionProperties);
        this.database.addDatabaseListener(new MCDatabaseListener());
        this.database.addExceptionListener(this);
        this.database.attach();
        this.gdsHelper = new GDSHelper(this.database);
    }

    @Override
    public void errorOccurred(Object source, SQLException ex) {
        log.trace(ex.getMessage());
        if (!FatalErrorHelper.isFatal(ex)) {
            return;
        }
        XcaConnectionEvent event = new XcaConnectionEvent(this, XcaConnectionEvent.EventType.CONNECTION_ERROR_OCCURRED, ex);
        this.notify(connectionErrorOccurredNotifier, event);
    }

    private FBConnectionRequestInfo getCombinedConnectionRequestInfo(FBConnectionRequestInfo cri) throws SQLException {
        if (cri == null) {
            return this.mcf.getDefaultConnectionRequestInfo();
        }
        return cri;
    }

    public GDSHelper getGDSHelper() throws SQLException {
        if (this.gdsHelper == null) {
            throw new FbExceptionBuilder().exception(335544363).toSQLException();
        }
        return this.gdsHelper;
    }

    @Deprecated
    public String getDatabase() {
        return this.mcf.getDatabaseName();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnvironment;
    }

    public boolean inTransaction() {
        return this.gdsHelper != null && this.gdsHelper.inTransaction();
    }

    public void setManagedEnvironment(boolean managedEnvironment) throws SQLException {
        this.managedEnvironment = managedEnvironment;
        FBConnection connection = this.connectionHandle;
        if (connection != null) {
            connection.setManagedEnvironment(managedEnvironment);
        }
    }

    public FBLocalTransaction getLocalTransaction() {
        return new FBLocalTransaction(this);
    }

    public void addConnectionEventListener(XcaConnectionEventListener listener) {
        this.connectionEventListeners.add(listener);
    }

    public void removeConnectionEventListener(XcaConnectionEventListener listener) {
        this.connectionEventListeners.remove(listener);
    }

    public void cleanup() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.disassociateConnections();
            this.getGDSHelper().setCurrentTransaction(null);
            this.transactionMapping = null;
            this.tpb = this.mcf.getDefaultTpb();
            this.transactionIsolation = this.mcf.getDefaultTransactionIsolation();
        }
    }

    private void disassociateConnections() throws SQLException {
        FBConnection connection = this.connectionHandle;
        if (connection != null) {
            connection.close();
        }
    }

    private void forceDisassociateConnections() {
        FBConnection connection = connectionHandleUpdater.getAndSet(this, null);
        if (connection != null) {
            try {
                connection.setManagedConnection(null);
                connection.close();
            }
            catch (SQLException sqlex) {
                log.debug("Exception ignored during forced disassociation", sqlex);
            }
        }
    }

    public FBConnection getConnection() throws SQLException {
        SQLWarning warnings;
        this.disassociateConnections();
        FBConnection c = this.mcf.newConnection(this);
        c.setManagedEnvironment(this.isManagedEnvironment());
        FBConnection previous = connectionHandleUpdater.getAndSet(this, c);
        if (previous != null) {
            previous.setManagedConnection(null);
            if (log.isDebugEnabled()) {
                log.debug("A connection was already associated with the managed connection", new RuntimeException("debug call trace"));
            }
            try {
                previous.setManagedConnection(null);
                previous.close();
            }
            catch (SQLException e) {
                log.debug("Error forcing previous connection to close", e);
            }
        }
        if ((warnings = (SQLWarning)unnotifiedWarningsUpdater.getAndSet(this, null)) != null) {
            c.addWarning(warnings);
        }
        return c;
    }

    public void destroy() throws SQLException {
        this.destroy(null);
    }

    public void destroy(XcaConnectionEvent connectionEvent) throws SQLException {
        if (this.gdsHelper == null) {
            return;
        }
        try {
            if (this.isBrokenConnection(connectionEvent)) {
                FbDatabase currentDatabase = this.gdsHelper.getCurrentDatabase();
                currentDatabase.forceClose();
            } else {
                if (this.inTransaction()) {
                    throw new SQLException("Can't destroy managed connection with active transaction");
                }
                this.gdsHelper.detachDatabase();
            }
        }
        finally {
            this.gdsHelper = null;
            this.forceDisassociateConnections();
        }
    }

    private boolean isBrokenConnection(XcaConnectionEvent connectionEvent) {
        if (connectionEvent == null || connectionEvent.getEventType() != XcaConnectionEvent.EventType.CONNECTION_ERROR_OCCURRED) {
            return false;
        }
        return FatalErrorHelper.isBrokenConnection(connectionEvent.getException());
    }

    public XAResource getXAResource() {
        log.debug("XAResource requested from FBManagedConnection");
        try (LockCloseable ignored = this.withLock();){
            if (this.xaResource == null) {
                this.xaResource = new FbMcXaResource();
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }

    boolean isXidActive(Xid xid) {
        FbTransaction transaction = this.xidMap.get(xid);
        return transaction != null && XID_ACTIVE_STATE.contains((Object)transaction.getState());
    }

    private void commit(Xid id, boolean onePhase) throws XAException {
        this.mcf.notifyCommit(this, id, onePhase);
    }

    void internalCommit(Xid xid, boolean onePhase) throws XAException {
        log.tracef("Commit called: %s", (Object)xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (onePhase && this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit one-phase when transaction has been prepared", -6);
        }
        if (!onePhase && !this.isPrepared(xid)) {
            throw new FBXAException("Cannot commit two-phase when transaction has not been prepared", -6);
        }
        if (committingTr == null) {
            throw new FBXAException("Commit called with unknown transaction", -4);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Commit called with non-ended xid", -6);
            }
            committingTr.commit();
        }
        catch (SQLException ge) {
            if (this.gdsHelper != null) {
                try {
                    committingTr.rollback();
                }
                catch (SQLException ge2) {
                    log.debug("Exception rolling back failed tx: ", ge2);
                }
            } else {
                log.warn("Unable to rollback failed tx, connection closed or lost");
            }
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
        finally {
            this.xidMap.remove(xid);
            this.preparedXid.remove(xid);
        }
    }

    private boolean isPrepared(Xid xid) {
        return this.preparedXid.contains(xid);
    }

    private void end(Xid id, int flags) throws XAException {
        if (flags != 0x4000000 && flags != 0x20000000 && flags != 0x2000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSUCCESS, TMFAIL, TMSUSPEND", -6);
        }
        this.internalEnd(id, flags);
        this.mcf.notifyEnd(this, id);
        this.inDistributedTransaction = false;
        try {
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (SQLException ex) {
            throw new FBXAException("Reset of managed state failed", -3, ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void internalEnd(Xid xid, int flags) throws XAException {
        log.debugf("End called: %s", (Object)xid);
        FbTransaction endingTr = this.xidMap.get(xid);
        if (endingTr == null) {
            throw new FBXAException("Unrecognized transaction", -4);
        }
        if (flags == 0x20000000) {
            try {
                endingTr.rollback();
                this.getGDSHelper().setCurrentTransaction(null);
                return;
            }
            catch (SQLException ex) {
                throw new FBXAException("can't rollback transaction", -7, ex);
            }
        } else if (flags == 0x4000000) {
            if (this.gdsHelper == null || endingTr != this.gdsHelper.getCurrentTransaction()) throw new FBXAException("You are trying to end a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTransaction(null);
            return;
        } else {
            if (flags != 0x2000000) return;
            if (this.gdsHelper == null || endingTr != this.gdsHelper.getCurrentTransaction()) throw new FBXAException("You are trying to suspend a transaction that is not the current transaction", -5);
            this.gdsHelper.setCurrentTransaction(null);
        }
    }

    private XidQueries getXidQueries() {
        return XidQueries.forVersion(this.database.getServerVersion());
    }

    private void forget(Xid id) throws XAException {
        FbStatement stmtHandle2;
        FbTransaction trHandle2;
        long inLimboId = -1L;
        try {
            trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(this.getXidQueries().forgetFindQuery());
            DataProvider dataProvider = new DataProvider(stmtHandle2);
            stmtHandle2.addStatementListener(dataProvider);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper2, false);
            while (dataProvider.next()) {
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                try {
                    FBXid xid = new FBXid(inLimboMessage, inLimboTxId);
                    boolean gtridEquals = Arrays.equals(xid.getGlobalTransactionId(), id.getGlobalTransactionId());
                    boolean bqualEquals = Arrays.equals(xid.getBranchQualifier(), id.getBranchQualifier());
                    if (!gtridEquals || !bqualEquals) continue;
                    inLimboId = inLimboTxId;
                    break;
                }
                catch (FBIncorrectXidException ex) {
                    log.warnDebug("incorrect XID format in RDB$TRANSACTIONS where RDB$TRANSACTION_ID=" + inLimboTxId, ex);
                }
            }
            stmtHandle2.close();
            trHandle2.commit();
        }
        catch (SQLException ex) {
            log.debug("can't perform query to fetch xids", ex);
            throw new FBXAException(-7, ex);
        }
        if (inLimboId == -1L) {
            throw new FBXAException("XID not found", -4);
        }
        try {
            trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            stmtHandle2 = this.database.createStatement(trHandle2);
            stmtHandle2.prepare(this.getXidQueries().forgetDelete() + inLimboId);
            stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
            stmtHandle2.close();
            trHandle2.commit();
        }
        catch (SQLException ex) {
            throw new FBXAException("can't perform query to fetch xids", -7, ex);
        }
    }

    private int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    private int prepare(Xid xid) throws XAException {
        return this.mcf.notifyPrepare(this, xid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int internalPrepare(Xid xid) throws FBXAException {
        log.tracef("prepare called: %s", (Object)xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (committingTr == null) {
            throw new FBXAException("Prepare called with unknown transaction", -4);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Prepare called with non-ended xid", -6);
            }
            FBXid fbxid = xid instanceof FBXid ? (FBXid)xid : new FBXid(xid);
            byte[] message = fbxid.toBytes();
            committingTr.prepare(message);
        }
        catch (SQLException ge) {
            try {
                if (this.gdsHelper != null) {
                    committingTr.rollback();
                } else {
                    log.warn("Unable to rollback failed tx, connection closed or lost");
                }
            }
            catch (SQLException ge2) {
                log.debug("Exception rolling back failed tx: ", ge2);
            }
            finally {
                this.xidMap.remove(xid);
            }
            log.warn("error in prepare", ge);
            throw new FBXAException(-3, ge);
        }
        this.preparedXid.add(xid);
        return 0;
    }

    private Xid[] recover(int flags) throws XAException {
        if (flags != 0x1000000 && flags != 0x800000 && flags != 0 && flags != 0x1800000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMSTARTRSCAN, TMENDRSCAN, TMNOFLAGS, TMSTARTRSCAN|TMENDRSCAN", -6);
        }
        try {
            ArrayList<FBXid> xids = new ArrayList<FBXid>();
            FbTransaction trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            FbStatement stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(this.getXidQueries().recoveryQuery());
            DataProvider dataProvider = new DataProvider(stmtHandle2);
            stmtHandle2.addStatementListener(dataProvider);
            stmtHandle2.execute(RowValue.EMPTY_ROW_VALUE);
            stmtHandle2.fetchRows(10);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper2, false);
            while (dataProvider.next()) {
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                FBXid xid = FBManagedConnection.extractXid(inLimboMessage, inLimboTxId);
                if (xid == null) continue;
                xids.add(xid);
            }
            stmtHandle2.close();
            trHandle2.commit();
            return xids.toArray(new FBXid[0]);
        }
        catch (IOException | SQLException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, e);
        }
    }

    private static FBXid extractXid(byte[] xidData, long txId) throws IOException {
        try {
            return new FBXid(xidData, txId);
        }
        catch (FBIncorrectXidException e) {
            log.warnf("ignoring XID stored with invalid format in RDB$TRANSACTIONS for RDB$TRANSACTION_ID=%d: %s", (Object)txId, (Object)ByteArrayHelper.toHexString(xidData));
            return null;
        }
    }

    Xid findSingleXid(Xid externalXid) throws XAException {
        try {
            FbTransaction trHandle2 = this.database.startTransaction(this.tpb.getTransactionParameterBuffer());
            FbStatement stmtHandle2 = this.database.createStatement(trHandle2);
            GDSHelper gdsHelper2 = new GDSHelper(this.database);
            gdsHelper2.setCurrentTransaction(trHandle2);
            stmtHandle2.prepare(this.getXidQueries().recoveryQueryParameterized());
            DataProvider dataProvider = new DataProvider(stmtHandle2);
            stmtHandle2.addStatementListener(dataProvider);
            FBXid tempXid = new FBXid(externalXid);
            RowValue parameters = RowValue.of(stmtHandle2.getParameterDescriptor(), (byte[][])new byte[][]{tempXid.toBytes()});
            stmtHandle2.execute(parameters);
            stmtHandle2.fetchRows(1);
            FBField field0 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(0), dataProvider.asFieldDataProvider(0), gdsHelper2, false);
            FBField field1 = FBField.createField(stmtHandle2.getRowDescriptor().getFieldDescriptor(1), dataProvider.asFieldDataProvider(1), gdsHelper2, false);
            FBXid xid = null;
            if (dataProvider.next()) {
                long inLimboTxId = field0.getLong();
                byte[] inLimboMessage = field1.getBytes();
                xid = FBManagedConnection.extractXid(inLimboMessage, inLimboTxId);
            }
            stmtHandle2.close();
            trHandle2.commit();
            return xid;
        }
        catch (IOException | SQLException e) {
            throw new FBXAException("can't perform query to fetch xids", -7, e);
        }
    }

    public LockCloseable withLock() {
        return this.database.withLock();
    }

    public boolean isLockedByCurrentThread() {
        return this.database.isLockedByCurrentThread();
    }

    private void rollback(Xid xid) throws XAException {
        this.mcf.notifyRollback(this, xid);
    }

    void internalRollback(Xid xid) throws XAException {
        log.tracef("rollback called: %s", (Object)xid);
        FbTransaction committingTr = this.xidMap.get(xid);
        if (committingTr == null) {
            throw new FBXAException("Rollback called with unknown transaction: " + xid);
        }
        try {
            if (committingTr == this.getGDSHelper().getCurrentTransaction()) {
                throw new FBXAException("Rollback called with non-ended xid", -6);
            }
            try {
                committingTr.rollback();
            }
            finally {
                this.xidMap.remove(xid);
                this.preparedXid.remove(xid);
            }
        }
        catch (SQLException ge) {
            log.debug("Exception in rollback", ge);
            throw new FBXAException(ge.getMessage(), -3, ge);
        }
    }

    private boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public boolean inDistributedTransaction() {
        return this.inDistributedTransaction;
    }

    private void start(Xid id, int flags) throws XAException {
        if (flags != 0 && flags != 0x200000 && flags != 0x8000000) {
            throw new FBXAException("flag not allowed in this context: " + flags + ", valid flags are TMNOFLAGS, TMJOIN, TMRESUME", -6);
        }
        if (flags == 0x200000) {
            throw new FBXAException("Joining two transactions is not supported", -7);
        }
        try {
            this.setTransactionIsolation(this.mcf.getDefaultTransactionIsolation());
            this.internalStart(id, flags);
            this.mcf.notifyStart(this, id);
            this.inDistributedTransaction = true;
            this.setManagedEnvironment(this.isManagedEnvironment());
        }
        catch (SQLException e) {
            throw new FBXAException(-3, e);
        }
    }

    public void internalStart(Xid id, int flags) throws XAException, SQLException {
        log.tracef("start called: %s", (Object)id);
        if (this.getGDSHelper().getCurrentTransaction() != null) {
            throw new FBXAException("Transaction already started", -6);
        }
        this.findIscTrHandle(id, flags);
    }

    public void close(FBConnection c) {
        c.setManagedConnection(null);
        if (!connectionHandleUpdater.compareAndSet(this, c, null) && log.isDebugEnabled()) {
            log.debug("Call of close for connection not currently associated with this managed connection", new RuntimeException("debug call trace"));
        }
        XcaConnectionEvent ce = new XcaConnectionEvent(this, XcaConnectionEvent.EventType.CONNECTION_CLOSED);
        ce.setConnectionHandle(c);
        this.notify(connectionClosedNotifier, ce);
    }

    public FBConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    public TransactionParameterBuffer getTransactionParameters() {
        try (LockCloseable ignored = this.withLock();){
            TransactionParameterBuffer transactionParameterBuffer = this.tpb.getTransactionParameterBuffer();
            return transactionParameterBuffer;
        }
    }

    public void setTransactionParameters(TransactionParameterBuffer transactionParameters) {
        try (LockCloseable ignored = this.withLock();){
            this.tpb.setTransactionParameterBuffer(transactionParameters);
        }
    }

    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        try (LockCloseable ignored = this.withLock();){
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                TransactionParameterBuffer transactionParameterBuffer = this.mcf.getTransactionParameters(isolation);
                return transactionParameterBuffer;
            }
            TransactionParameterBuffer transactionParameterBuffer = mapping.getMapping(isolation);
            return transactionParameterBuffer;
        }
    }

    public void setTransactionParameters(int isolation, TransactionParameterBuffer transactionParams) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            FBTpbMapper mapping = this.transactionMapping;
            if (mapping == null) {
                mapping = this.transactionMapping = this.mcf.getTransactionMappingCopy();
            }
            mapping.setMapping(isolation, transactionParams);
            if (this.getTransactionIsolation() == isolation) {
                this.setTransactionIsolation(isolation);
            }
        }
    }

    private void findIscTrHandle(Xid xid, int flags) throws SQLException, XAException {
        this.getGDSHelper().setCurrentTransaction(null);
        if (flags == 0x8000000) {
            FbTransaction trHandle = this.xidMap.get(xid);
            if (trHandle == null) {
                throw new FBXAException("You are trying to resume a transaction that is not attached to this XAResource", -5);
            }
            this.getGDSHelper().setCurrentTransaction(trHandle);
            return;
        }
        for (Xid knownXid : this.xidMap.keySet()) {
            boolean sameFormatId = knownXid.getFormatId() == xid.getFormatId();
            boolean sameGtrid = Arrays.equals(knownXid.getGlobalTransactionId(), xid.getGlobalTransactionId());
            boolean sameBqual = Arrays.equals(knownXid.getBranchQualifier(), xid.getBranchQualifier());
            if (!sameFormatId || !sameGtrid || !sameBqual) continue;
            throw new FBXAException("A transaction with the same XID has already been started", -8);
        }
        try {
            FbTransaction transaction = this.getGDSHelper().startTransaction(this.tpb.getTransactionParameterBuffer());
            this.xidMap.put(xid, transaction);
        }
        catch (SQLException e) {
            throw new FBXAException(e.getMessage(), -3, e);
        }
    }

    void notify(CELNotifier notifier, XcaConnectionEvent ce) {
        for (XcaConnectionEventListener cel : this.connectionEventListeners) {
            notifier.notify(cel, ce);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            int n = this.transactionIsolation;
            return n;
        }
    }

    public void setTransactionIsolation(int isolation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.transactionIsolation = isolation;
            FBTpbMapper mapping = this.transactionMapping;
            this.tpb = mapping == null ? this.mcf.getTpb(isolation) : new FBTpb(mapping.getMapping(isolation));
        }
    }

    public FBManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public void setReadOnly(boolean readOnly) {
        this.tpb.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.tpb.isReadOnly();
    }

    private void notifyWarning(SQLWarning warning) {
        FBConnection connection = this.connectionHandle;
        if (connection == null) {
            while (!unnotifiedWarningsUpdater.compareAndSet(this, null, warning)) {
                SQLWarning warnings = this.unnotifiedWarnings;
                if (warnings == null) continue;
                warnings.setNextWarning(warning);
                break;
            }
        } else {
            SQLWarning warnings = unnotifiedWarningsUpdater.getAndSet(this, null);
            if (warnings != null) {
                warnings.setNextWarning(warning);
                warning = warnings;
            }
            connection.addWarning(warning);
        }
    }

    private static String getDefaultConnectionEncoding() {
        try {
            String defaultConnectionEncoding = JaybirdSystemProperties.getDefaultConnectionEncoding();
            if (defaultConnectionEncoding == null) {
                if (JaybirdSystemProperties.isRequireConnectionEncoding()) {
                    return null;
                }
                return "NONE";
            }
            return defaultConnectionEncoding;
        }
        catch (Exception e) {
            log.error("Exception obtaining default connection encoding", e);
            return "NONE";
        }
    }

    private static final class XidQueriesFB21
    implements XidQueries {
        static final XidQueriesFB21 INSTANCE = new XidQueriesFB21();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS ";

        private XidQueriesFB21() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE IN (2, 3)";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return FIND_TRANSACTION_FRAGMENT;
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS where RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }

    private static final class XidQueriesFB25
    implements XidQueries {
        static final XidQueriesFB25 INSTANCE = new XidQueriesFB25();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS ";

        private XidQueriesFB25() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE IN (2, 3) and RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS  where RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, RDB$TRANSACTION_DESCRIPTION from RDB$TRANSACTIONS where RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }

    private static final class XidQueriesFB30
    implements XidQueries {
        static final XidQueriesFB30 INSTANCE = new XidQueriesFB30();
        private static final String FIND_TRANSACTION_FRAGMENT = "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets) from RDB$TRANSACTIONS ";

        private XidQueriesFB30() {
        }

        @Override
        public String forgetFindQuery() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets) from RDB$TRANSACTIONS WHERE RDB$TRANSACTION_STATE IN (2, 3) and RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String forgetDelete() {
            return "delete from RDB$TRANSACTIONS where RDB$TRANSACTION_ID = ";
        }

        @Override
        public String recoveryQuery() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets) from RDB$TRANSACTIONS  where RDB$TRANSACTION_DESCRIPTION starting with x'0105'";
        }

        @Override
        public String recoveryQueryParameterized() {
            return "select RDB$TRANSACTION_ID, cast(RDB$TRANSACTION_DESCRIPTION as varchar(32764) character set octets) from RDB$TRANSACTIONS where RDB$TRANSACTION_DESCRIPTION = cast(? AS varchar(32764) character set octets)";
        }
    }

    private static interface XidQueries {
        public String forgetFindQuery();

        public String forgetDelete();

        public String recoveryQuery();

        public String recoveryQueryParameterized();

        public static XidQueries forVersion(GDSServerVersion version) {
            if (version.isEqualOrAbove(3, 0)) {
                return XidQueriesFB30.INSTANCE;
            }
            if (version.isEqualOrAbove(2, 5)) {
                return XidQueriesFB25.INSTANCE;
            }
            return XidQueriesFB21.INSTANCE;
        }
    }

    private final class FbMcXaResource
    implements XAResource {
        private FbMcXaResource() {
        }

        private FBManagedConnection getMc() {
            return FBManagedConnection.this;
        }

        @Override
        public void start(Xid xid, int flags) throws XAException {
            FBManagedConnection.this.start(xid, flags);
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            return FBManagedConnection.this.prepare(xid);
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            FBManagedConnection.this.commit(xid, onePhase);
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            FBManagedConnection.this.rollback(xid);
        }

        @Override
        public void end(Xid xid, int flags) throws XAException {
            FBManagedConnection.this.end(xid, flags);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            FBManagedConnection.this.forget(xid);
        }

        @Override
        public Xid[] recover(int flag) throws XAException {
            return FBManagedConnection.this.recover(flag);
        }

        @Override
        public boolean isSameRM(XAResource res) throws XAException {
            return res == this || res instanceof FbMcXaResource && FBManagedConnection.this.database == ((FbMcXaResource)res).getMc().database;
        }

        @Override
        public int getTransactionTimeout() throws XAException {
            return FBManagedConnection.this.getTransactionTimeout();
        }

        @Override
        public boolean setTransactionTimeout(int seconds) throws XAException {
            return FBManagedConnection.this.setTransactionTimeout(seconds);
        }
    }

    private final class MCDatabaseListener
    implements DatabaseListener {
        private MCDatabaseListener() {
        }

        @Override
        public void warningReceived(FbDatabase database, SQLWarning warning) {
            if (database != FBManagedConnection.this.database) {
                database.removeDatabaseListener(this);
                return;
            }
            FBManagedConnection.this.notifyWarning(warning);
        }
    }

    @FunctionalInterface
    static interface CELNotifier {
        public void notify(XcaConnectionEventListener var1, XcaConnectionEvent var2);
    }

    private static final class DataProvider
    implements StatementListener {
        private final Deque<RowValue> rows = new ArrayDeque<RowValue>();
        private final FbStatement statementHandle;
        private RowValue currentRow = null;
        private boolean moreRows = true;

        private DataProvider(FbStatement statementHandle) {
            this.statementHandle = statementHandle;
        }

        boolean hasNext() throws SQLException {
            if (this.rows.isEmpty() && this.moreRows) {
                this.fetch();
            }
            return !this.rows.isEmpty();
        }

        boolean next() throws SQLException {
            if (this.hasNext()) {
                this.currentRow = Objects.requireNonNull(this.rows.pollFirst(), "row");
                return true;
            }
            this.currentRow = null;
            return false;
        }

        private void fetch() throws SQLException {
            this.statementHandle.fetchRows(Integer.MAX_VALUE);
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        @Override
        public void afterLast(FbStatement sender) {
            this.moreRows = false;
        }

        FieldDataProvider asFieldDataProvider(final int fieldPos) {
            return new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    return currentRow.getFieldData(fieldPos);
                }

                @Override
                public void setFieldData(byte[] data) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

