/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.parser;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;

class UnicodeDetectingInputStream
extends FilterInputStream {
    private static final Charset UTF_8;
    private static final Charset UTF_16BE;
    private static final Charset UTF_16LE;
    private static final Charset UTF_32LE;
    private static final Charset UTF_32BE;
    private static final byte FF = -1;
    private static final byte FE = -2;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final byte NUL = 0;
    private final byte[] buf = new byte[4];
    private int bufLen;
    private int curIndex;
    private final Charset charset = this.detectEncoding();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    UnicodeDetectingInputStream(InputStream is) {
        super(is);
    }

    Charset getCharset() {
        return this.charset;
    }

    private OracleJsonExceptions.ExceptionFactory factory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }

    private void fillBuf() {
        try {
            int b1 = this.in.read();
            if (b1 == -1) {
                return;
            }
            int b2 = this.in.read();
            if (b2 == -1) {
                this.bufLen = 1;
                this.buf[0] = (byte)b1;
                return;
            }
            int b3 = this.in.read();
            if (b3 == -1) {
                this.bufLen = 2;
                this.buf[0] = (byte)b1;
                this.buf[1] = (byte)b2;
                return;
            }
            int b4 = this.in.read();
            if (b4 == -1) {
                this.bufLen = 3;
                this.buf[0] = (byte)b1;
                this.buf[1] = (byte)b2;
                this.buf[2] = (byte)b3;
                return;
            }
            this.bufLen = 4;
            this.buf[0] = (byte)b1;
            this.buf[1] = (byte)b2;
            this.buf[2] = (byte)b3;
            this.buf[3] = (byte)b4;
        }
        catch (IOException ioe) {
            throw OracleJsonExceptions.IO.create(this.factory(), new Object[0]);
        }
    }

    private Charset detectEncoding() {
        this.fillBuf();
        if (this.bufLen < 2) {
            throw OracleJsonExceptions.PARSER_ENC_DETECT_FAIL.create(this.factory(), new Object[0]);
        }
        if (this.bufLen == 4) {
            if (this.buf[0] == 0 && this.buf[1] == 0 && this.buf[2] == -2 && this.buf[3] == -1) {
                this.curIndex = 4;
                return UTF_32BE;
            }
            if (this.buf[0] == -1 && this.buf[1] == -2 && this.buf[2] == 0 && this.buf[3] == 0) {
                this.curIndex = 4;
                return UTF_32LE;
            }
            if (this.buf[0] == -2 && this.buf[1] == -1) {
                this.curIndex = 2;
                return UTF_16BE;
            }
            if (this.buf[0] == -1 && this.buf[1] == -2) {
                this.curIndex = 2;
                return UTF_16LE;
            }
            if (this.buf[0] == -17 && this.buf[1] == -69 && this.buf[2] == -65) {
                this.curIndex = 3;
                return UTF_8;
            }
            if (this.buf[0] == 0 && this.buf[1] == 0 && this.buf[2] == 0) {
                return UTF_32BE;
            }
            if (this.buf[0] == 0 && this.buf[2] == 0) {
                return UTF_16BE;
            }
            if (this.buf[1] == 0 && this.buf[2] == 0 && this.buf[3] == 0) {
                return UTF_32LE;
            }
            if (this.buf[1] == 0 && this.buf[3] == 0) {
                return UTF_16LE;
            }
        }
        return UTF_8;
    }

    @Override
    public int read() throws IOException {
        if (this.curIndex < this.bufLen) {
            return this.buf[this.curIndex++];
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.curIndex < this.bufLen) {
            if (len == 0) {
                return 0;
            }
            if (off < 0 || len < 0 || len > b2.length - off) {
                throw new IndexOutOfBoundsException();
            }
            int min = Math.min(this.bufLen - this.curIndex, len);
            System.arraycopy(this.buf, this.curIndex, b2, off, min);
            this.curIndex += min;
            return min;
        }
        return this.in.read(b2, off, len);
    }

    static {
        try {
            $$$methodRef$$$6 = UnicodeDetectingInputStream.class.getDeclaredConstructor(InputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = UnicodeDetectingInputStream.class.getDeclaredMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = UnicodeDetectingInputStream.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = UnicodeDetectingInputStream.class.getDeclaredMethod("detectEncoding", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = UnicodeDetectingInputStream.class.getDeclaredMethod("fillBuf", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = UnicodeDetectingInputStream.class.getDeclaredMethod("factory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = UnicodeDetectingInputStream.class.getDeclaredMethod("getCharset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        UTF_8 = Charset.forName("UTF-8");
        UTF_16BE = Charset.forName("UTF-16BE");
        UTF_16LE = Charset.forName("UTF-16LE");
        UTF_32LE = Charset.forName("UTF-32LE");
        UTF_32BE = Charset.forName("UTF-32BE");
    }
}

