/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.auth.oauth2;

import java.io.IOException;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpExecuteInterceptor;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequestInitializer;
import net.snowflake.client.jdbc.internal.google.api.client.http.UrlEncodedContent;
import net.snowflake.client.jdbc.internal.google.api.client.util.Data;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;

public class ClientParametersAuthentication
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final String clientId;
    private final String clientSecret;

    public ClientParametersAuthentication(String clientId, String clientSecret) {
        this.clientId = Preconditions.checkNotNull(clientId);
        this.clientSecret = clientSecret;
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        Map<String, Object> data = Data.mapOf(UrlEncodedContent.getContent(request).getData());
        data.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            data.put("client_secret", this.clientSecret);
        }
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientSecret() {
        return this.clientSecret;
    }
}

