/*
 * MIT License
 *
 * Copyright (c) 2020 Open Compute Project
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef OAM_INCLUDE_OAM_AMD_OAM_H_
#define OAM_INCLUDE_OAM_AMD_OAM_H_

#ifdef __cplusplus
extern "C" {
#include <cstdint>
#else
#include <stdint.h>
#endif  // __cplusplus

#include "oam/oam_mapi.h"

typedef enum {
  AMDOAM_STATUS_SUCCESS = 0x0,
  /* copy RSMI errors */
  AMDOAM_STATUS_INVALID_ARGS,
  AMDOAM_STATUS_NOT_SUPPORTED,
  AMDOAM_STATUS_FILE_ERROR,
  AMDOAM_STATUS_PERMISSION,
  AMDOAM_STATUS_OUT_OF_RESOURCES,
  AMDOAM_STATUS_INTERNAL_EXCEPTION,
  AMDOAM_STATUS_INPUT_OUT_OF_BOUNDS,
  AMDOAM_STATUS_INIT_ERROR,
  /* end of RSMI error code */
  AMDOAM_STATUS_ERROR,  // Generic error return if not otherwise specified
  AMDOAM_STATUS_NOT_FOUND,
} amdoam_status_t;

int amdoam_init(void);
int amdoam_free(void);
// int amdoam_get_mapi_version(oam_mapi_version_t *version);
int amdoam_discover_devices(uint32_t *device_count);
int amdoam_get_dev_properties(uint32_t dev_inx,
                              oam_dev_properties_t *prop);
int amdoam_get_pci_properties(uint32_t device_id, oam_pci_info_t *pci_info);
int amdoam_get_sensors_count(uint32_t device_id,
                             oam_sensor_count_t *sensor_count);
int amdoam_get_error_description(int code, const char **description);
int amdoam_get_sensors_info(uint32_t device_id, oam_sensor_type_t type,
                uint32_t num_sensors, oam_sensor_info_t sensor_info[]);

#ifdef __cplusplus
}
#endif  // __cplusplus
#endif  // OAM_INCLUDE_OAM_AMD_OAM_H_
