/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.ngram.model.counter;

import com.intellij.platform.ml.impl.ngram.model.NGramToken;
import com.intellij.platform.ml.impl.ngram.model.counter.NGramCounter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012,\u0010\u0003\u001a(\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00060\u0005j\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\u0007\u0012\u0004\u0012\u00020\b0\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ*\u0010\f\u001a\u00020\b2 \u0010\r\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00060\u0005j\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\u0007H\u0016J.\u0010\u000e\u001a(\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00060\u0005j\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\u0007\u0012\u0004\u0012\u00020\b0\u0004H\u0016R4\u0010\u0003\u001a(\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00060\u0005j\n\u0012\u0006\b\u0001\u0012\u00028\u0000`\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramHashMapCounter;", "T", "Lcom/intellij/platform/ml/impl/ngram/model/counter/NGramCounter;", "mapToFrequency", "", "", "Lcom/intellij/platform/ml/impl/ngram/model/NGramToken;", "Lcom/intellij/platform/ml/impl/ngram/model/NGram;", "", "ngramSize", "<init>", "(Ljava/util/Map;I)V", "getFrequencyOf", "ngram", "getAllNGramsWithCount", "intellij.platform.ml.impl"})
@SourceDebugExtension(value={"SMAP\nNGramHashMapCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NGramHashMapCounter.kt\ncom/intellij/platform/ml/impl/ngram/model/counter/NGramHashMapCounter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,33:1\n488#2,7:34\n*S KotlinDebug\n*F\n+ 1 NGramHashMapCounter.kt\ncom/intellij/platform/ml/impl/ngram/model/counter/NGramHashMapCounter\n*L\n28#1:34,7\n*E\n"})
public final class NGramHashMapCounter<T>
implements NGramCounter<T> {
    @NotNull
    private final Map<List<NGramToken<? extends T>>, Integer> mapToFrequency;
    private final int ngramSize;

    public NGramHashMapCounter(@NotNull Map<List<NGramToken<? extends T>>, Integer> mapToFrequency, int ngramSize) {
        Intrinsics.checkNotNullParameter(mapToFrequency, (String)"mapToFrequency");
        this.mapToFrequency = mapToFrequency;
        this.ngramSize = ngramSize;
    }

    @Override
    public int getFrequencyOf(@NotNull List<? extends NGramToken<? extends T>> ngram) {
        int n;
        Intrinsics.checkNotNullParameter(ngram, (String)"ngram");
        if (ngram.size() == this.ngramSize) {
            Integer n2 = this.mapToFrequency.get(ngram);
            n = n2 != null ? n2 : 0;
        } else if (ngram.size() > this.ngramSize) {
            Integer n3 = this.mapToFrequency.get(CollectionsKt.takeLast(ngram, (int)this.ngramSize));
            n = n3 != null ? n3 : 0;
        } else {
            Map<List<NGramToken<T>>, Integer> $this$filterKeys$iv = this.mapToFrequency;
            boolean $i$f$filterKeys = false;
            LinkedHashMap<List<NGramToken<? extends T>>, Integer> result$iv = new LinkedHashMap<List<NGramToken<? extends T>>, Integer>();
            for (Map.Entry<List<NGramToken<T>>, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
                List<NGramToken<T>> it = entry$iv.getKey();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.subList(0, ngram.size()), ngram)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            n = CollectionsKt.sumOfInt((Iterable)((Map)result$iv).values());
        }
        return n;
    }

    @Override
    @NotNull
    public Map<List<NGramToken<? extends T>>, Integer> getAllNGramsWithCount() {
        return this.mapToFrequency;
    }
}

