/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.ui;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.impl.DiffRequestProcessorListener;
import com.intellij.diff.util.DiffUtil;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreview;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ActivitySelection;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.platform.lvcs.impl.ui.ActivityModelListener;
import com.intellij.platform.lvcs.impl.ui.ActivityViewModel;
import com.intellij.platform.lvcs.impl.ui.SingleFileActivityDiffPreviewKt;
import com.intellij.platform.lvcs.impl.ui.SingleFileActivityDiffRequestProcessor;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0010H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0017\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0012H\u0014J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/SingleFileActivityDiffPreview;", "Lcom/intellij/openapi/vcs/changes/EditorTabDiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;Lcom/intellij/openapi/Disposable;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/diff/impl/DiffRequestProcessorListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasContent", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "collectDiffProducers", "Lcom/intellij/openapi/ListSelection;", "Lcom/intellij/diff/chains/DiffRequestProducer;", "selectedOnly", "performDiffAction", "getEditorTabName", "", "Lorg/jetbrains/annotations/Nls;", "processor", "addListener", "", "listener", "addListener$intellij_platform_lvcs_impl", "Companion", "intellij.platform.lvcs.impl"})
public final class SingleFileActivityDiffPreview
extends EditorTabDiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActivityViewModel model;
    @NotNull
    private final EventDispatcher<DiffRequestProcessorListener> eventDispatcher;
    @NotNull
    public static final String DIFF_PLACE = "ActivityView";

    public SingleFileActivityDiffPreview(@NotNull Project project, @NotNull ActivityViewModel model, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super(project);
        this.model = model;
        EventDispatcher eventDispatcher = EventDispatcher.create(DiffRequestProcessorListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        Disposer.register((Disposable)disposable, (Disposable)((Disposable)this));
    }

    public boolean hasContent() {
        return this.model.getSelection$intellij_platform_lvcs_impl() != null;
    }

    @NotNull
    protected DiffEditorViewer createViewer() {
        DiffRequestProcessor diffRequestProcessor;
        DiffRequestProcessor viewer = diffRequestProcessor = Companion.createViewer$intellij_platform_lvcs_impl(this.getProject(), this.model);
        boolean bl = false;
        viewer.addListener(() -> SingleFileActivityDiffPreview.createViewer$lambda$0$0(this), (Disposable)this);
        return (DiffEditorViewer)diffRequestProcessor;
    }

    @Nullable
    protected ListSelection<DiffRequestProducer> collectDiffProducers(boolean selectedOnly) {
        DiffRequestProducer diffRequestProducer = SingleFileActivityDiffPreviewKt.access$getSingleDiffRequestProducer(this.model);
        if (diffRequestProducer == null) {
            return null;
        }
        DiffRequestProducer diffRequestProducer2 = diffRequestProducer;
        return ListSelection.createSingleton((Object)diffRequestProducer2);
    }

    public boolean performDiffAction() {
        LocalHistoryCounter.INSTANCE.logActionInvoked(LocalHistoryCounter.ActionKind.Diff, this.model.getActivityScope$intellij_platform_lvcs_impl());
        return super.performDiffAction();
    }

    @NotNull
    protected String getEditorTabName(@Nullable DiffEditorViewer processor) {
        ActivityScope activityScope = this.model.getActivityScope$intellij_platform_lvcs_impl();
        ActivityScope.File file = activityScope instanceof ActivityScope.File ? (ActivityScope.File)activityScope : null;
        return Companion.getDiffTitleFor((FilePath)(file != null ? ActivityScopeKt.getFilePath(file) : null), this.model.getActivityScope$intellij_platform_lvcs_impl());
    }

    public final void addListener$intellij_platform_lvcs_impl(@NotNull DiffRequestProcessorListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.eventDispatcher.addListener((EventListener)listener, disposable);
    }

    private static final void createViewer$lambda$0$0(SingleFileActivityDiffPreview this$0) {
        ((DiffRequestProcessorListener)this$0.eventDispatcher.getMulticaster()).onViewerChanged();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0006\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/lvcs/impl/ui/SingleFileActivityDiffPreview$Companion;", "", "<init>", "()V", "DIFF_PLACE", "", "getDiffTitleFor", "Lorg/jetbrains/annotations/Nls;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "activityScope", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "createViewer", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/platform/lvcs/impl/ui/ActivityViewModel;", "createViewer$intellij_platform_lvcs_impl", "intellij.platform.lvcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDiffTitleFor(@Nullable FilePath filePath, @NotNull ActivityScope activityScope) {
            Intrinsics.checkNotNullParameter((Object)activityScope, (String)"activityScope");
            if (filePath != null) {
                Object[] objectArray = new Object[]{filePath.getName()};
                String string = LocalHistoryBundle.message("activity.diff.tab.title.file", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            if (Intrinsics.areEqual((Object)activityScope, (Object)ActivityScope.Recent.INSTANCE)) {
                String string = LocalHistoryBundle.message("activity.diff.tab.title.recent", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            String string = LocalHistoryBundle.message("activity.diff.tab.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public final DiffRequestProcessor createViewer$intellij_platform_lvcs_impl(@NotNull Project project, @NotNull ActivityViewModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            SingleFileActivityDiffRequestProcessor processor = new SingleFileActivityDiffRequestProcessor(project, model);
            model.addListener(new ActivityModelListener(processor){
                final /* synthetic */ SingleFileActivityDiffRequestProcessor $processor;
                {
                    this.$processor = $processor;
                }

                public void onSelectionChanged(ActivitySelection selection) {
                    this.$processor.updatePreview();
                }
            }, (Disposable)processor);
            DiffUtil.installShowNotifyListener((JComponent)processor.getComponent(), () -> Companion.createViewer$lambda$0(processor));
            return (DiffRequestProcessor)processor;
        }

        private static final void createViewer$lambda$0(SingleFileActivityDiffRequestProcessor $processor) {
            $processor.updatePreview();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

