/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.ComponentPreconditions;
import org.assertj.swing.driver.ContainerDriver;
import org.assertj.swing.driver.WindowLikeContainers;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.internal.annotation.InternalApi;

@InternalApi
public class WindowDriver
extends ContainerDriver {
    public WindowDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void resizeWidthTo(@Nonnull Window w, int width) {
        this.doResizeWidth(w, width);
    }

    @RunsInEDT
    public void resizeHeightTo(@Nonnull Window w, int height) {
        this.doResizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(@Nonnull Window w, @Nonnull Dimension size) {
        this.resize(w, size.width, size.height);
    }

    public void moveTo(@Nonnull Window w, @Nonnull Point where) {
        this.move(w, where.x, where.y);
    }

    @RunsInEDT
    public void close(@Nonnull Window w) {
        this.moveMouseIgnoringAnyError(w, WindowDriver.closeInfo(w));
        this.robot.close(w);
    }

    @Nonnull
    @RunsInEDT
    private static Point closeInfo(@Nonnull Window w) {
        Point result = GuiActionRunner.execute(() -> {
            ComponentPreconditions.checkEnabledAndShowing(w);
            return WindowLikeContainers.closeButtonLocation(w);
        });
        return (Point)Preconditions.checkNotNull((Object)result);
    }

    @RunsInEDT
    public void show(@Nonnull Window w) {
        this.robot.showWindow(w);
    }

    @RunsInEDT
    public void show(@Nonnull Window w, @Nonnull Dimension size) {
        this.robot.showWindow(w, size);
    }

    @RunsInEDT
    public void moveToFront(@Nonnull Window w) {
        WindowDriver.doMoveToFront(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToFront(@Nonnull Window w) {
        GuiActionRunner.execute(() -> w.toFront());
    }

    @RunsInEDT
    public void moveToBack(@Nonnull Window w) {
        WindowDriver.doMoveToBack(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToBack(@Nonnull Window w) {
        GuiActionRunner.execute(() -> w.toBack());
    }
}

