/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetIpPrefixes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetIpPrefixes> {
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(SubnetIpPrefixes.getter(SubnetIpPrefixes::subnetId)).setter(SubnetIpPrefixes.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<List<String>> IP_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpPrefixes").getter(SubnetIpPrefixes.getter(SubnetIpPrefixes::ipPrefixes)).setter(SubnetIpPrefixes.setter(Builder::ipPrefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpPrefixSet").unmarshallLocationName("ipPrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_ID_FIELD, IP_PREFIXES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubnetIpPrefixes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subnetId;
    private final List<String> ipPrefixes;

    private SubnetIpPrefixes(BuilderImpl builder) {
        this.subnetId = builder.subnetId;
        this.ipPrefixes = builder.ipPrefixes;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final boolean hasIpPrefixes() {
        return this.ipPrefixes != null && !(this.ipPrefixes instanceof SdkAutoConstructList);
    }

    public final List<String> ipPrefixes() {
        return this.ipPrefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpPrefixes() ? this.ipPrefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetIpPrefixes)) {
            return false;
        }
        SubnetIpPrefixes other = (SubnetIpPrefixes)obj;
        return Objects.equals(this.subnetId(), other.subnetId()) && this.hasIpPrefixes() == other.hasIpPrefixes() && Objects.equals(this.ipPrefixes(), other.ipPrefixes());
    }

    public final String toString() {
        return ToString.builder((String)"SubnetIpPrefixes").add("SubnetId", (Object)this.subnetId()).add("IpPrefixes", this.hasIpPrefixes() ? this.ipPrefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "IpPrefixes": {
                return Optional.ofNullable(clazz.cast(this.ipPrefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("IpPrefixSet", IP_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetIpPrefixes, T> g) {
        return obj -> g.apply((SubnetIpPrefixes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetId;
        private List<String> ipPrefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetIpPrefixes model) {
            this.subnetId(model.subnetId);
            this.ipPrefixes(model.ipPrefixes);
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final Collection<String> getIpPrefixes() {
            if (this.ipPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipPrefixes;
        }

        public final void setIpPrefixes(Collection<String> ipPrefixes) {
            this.ipPrefixes = ValueStringListCopier.copy(ipPrefixes);
        }

        @Override
        public final Builder ipPrefixes(Collection<String> ipPrefixes) {
            this.ipPrefixes = ValueStringListCopier.copy(ipPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipPrefixes(String ... ipPrefixes) {
            this.ipPrefixes(Arrays.asList(ipPrefixes));
            return this;
        }

        public SubnetIpPrefixes build() {
            return new SubnetIpPrefixes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetIpPrefixes> {
        public Builder subnetId(String var1);

        public Builder ipPrefixes(Collection<String> var1);

        public Builder ipPrefixes(String ... var1);
    }
}

