/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprCollectionValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.LiteralExpression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;
import shaded.com.google.common.collect.ImmutableList;

public class ValuesOperator
extends PhysicalPlan {
    private final List<List<LiteralExpression>> values;
    private final Iterator<List<LiteralExpression>> valuesIterator;

    public ValuesOperator(List<List<LiteralExpression>> values) {
        this.values = values;
        this.valuesIterator = values.iterator();
    }

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitValues(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return ImmutableList.of();
    }

    @Override
    public boolean hasNext() {
        return this.valuesIterator.hasNext();
    }

    @Override
    public ExprValue next() {
        List<ExprValue> values = this.valuesIterator.next().stream().map(Expression::valueOf).collect(Collectors.toList());
        return new ExprCollectionValue(values);
    }

    @Generated
    public String toString() {
        return "ValuesOperator(values=" + String.valueOf(this.getValues()) + ", valuesIterator=" + String.valueOf(this.valuesIterator) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValuesOperator)) {
            return false;
        }
        ValuesOperator other = (ValuesOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<List<LiteralExpression>> this$values = this.getValues();
        List<List<LiteralExpression>> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValuesOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<List<LiteralExpression>> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    @Generated
    public List<List<LiteralExpression>> getValues() {
        return this.values;
    }
}

