/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans;

import com.install4j.api.beans.Anchor;
import javax.swing.JComponent;

public class AnchorUtil {
    private static final Anchor[][] ANCHOR_MATRIX = new Anchor[][]{{Anchor.NORTHWEST, Anchor.NORTH, Anchor.NORTHEAST}, {Anchor.WEST, Anchor.CENTER, Anchor.EAST}, {Anchor.SOUTHWEST, Anchor.SOUTH, Anchor.SOUTHEAST}};

    public static Anchor getAnchor(Anchor horizontalAnchor, Anchor verticalAnchor) {
        return ANCHOR_MATRIX[AnchorUtil.getVerticalIndex(verticalAnchor)][AnchorUtil.getHorizontalIndex(horizontalAnchor)];
    }

    private static int getHorizontalIndex(Anchor horizontalAnchor) {
        switch (horizontalAnchor) {
            case WEST: {
                return 0;
            }
            case CENTER: {
                return 1;
            }
            case EAST: {
                return 2;
            }
        }
        throw new IllegalStateException(horizontalAnchor.name());
    }

    private static int getVerticalIndex(Anchor verticalAnchor) {
        switch (verticalAnchor) {
            case NORTH: {
                return 0;
            }
            case CENTER: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
        }
        throw new IllegalStateException(verticalAnchor.name());
    }

    public static void setAlignments(JComponent component, Anchor anchor) {
        component.setAlignmentX(AnchorUtil.getAlignmentX(anchor));
        component.setAlignmentY(AnchorUtil.getAlignmentY(anchor));
    }

    private static float getAlignmentX(Anchor anchor) {
        switch (anchor) {
            case WEST: 
            case NORTHWEST: 
            case SOUTHWEST: {
                return 0.0f;
            }
            case CENTER: 
            case NORTH: 
            case SOUTH: {
                return 0.5f;
            }
            case EAST: 
            case NORTHEAST: 
            case SOUTHEAST: {
                return 1.0f;
            }
        }
        throw new IllegalArgumentException(anchor.name());
    }

    private static float getAlignmentY(Anchor anchor) {
        switch (anchor) {
            case NORTH: 
            case NORTHWEST: 
            case NORTHEAST: {
                return 0.0f;
            }
            case WEST: 
            case CENTER: 
            case EAST: {
                return 0.5f;
            }
            case SOUTH: 
            case SOUTHWEST: 
            case SOUTHEAST: {
                return 1.0f;
            }
        }
        throw new IllegalArgumentException(anchor.name());
    }

    public static int getAnchor(JComponent component) {
        int verticalIndex = AnchorUtil.getAnchorIndex(component.getAlignmentY());
        int horizontalIndex = AnchorUtil.getAnchorIndex(component.getAlignmentX());
        return ANCHOR_MATRIX[verticalIndex][horizontalIndex].getValue();
    }

    private static int getAnchorIndex(float alignment) {
        if (alignment < 0.5f) {
            return 0;
        }
        if (alignment > 0.5f) {
            return 2;
        }
        return 1;
    }
}

