/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.keycloak.validation.ValidationError;

public class ValidationResult {
    private final boolean valid;
    private final Set<ValidationError> errors;

    public ValidationResult(Set<ValidationError> errors) {
        this.valid = errors.size() == 0;
        this.errors = Collections.unmodifiableSet(errors);
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<ValidationError> getErrors() {
        return this.errors;
    }

    public String getAllErrorsAsString() {
        return this.getAllErrorsAsString(ValidationError::getMessage);
    }

    public String getAllLocalizedErrorsAsString(Properties messagesBundle) {
        return this.getAllErrorsAsString(x -> x.getLocalizedMessage(messagesBundle));
    }

    protected String getAllErrorsAsString(Function<ValidationError, String> function) {
        return this.errors.stream().map(function).collect(Collectors.joining("; "));
    }

    public boolean fieldHasError(String fieldId) {
        if (fieldId == null) {
            return false;
        }
        for (ValidationError error : this.errors) {
            if (!fieldId.equals(error.getFieldId())) continue;
            return true;
        }
        return false;
    }
}

