/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.authorizer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.controller.ControllerRequestContext;
import org.apache.kafka.metadata.authorizer.AclMutator;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;

public interface ClusterMetadataAuthorizer
extends Authorizer {
    public void setAclMutator(AclMutator var1);

    public AclMutator aclMutatorOrException();

    public void completeInitialLoad();

    public void completeInitialLoad(Exception var1);

    public void loadSnapshot(Map<Uuid, StandardAcl> var1);

    public void addAcl(Uuid var1, StandardAcl var2);

    public void removeAcl(Uuid var1);

    default public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        ArrayList futures = new ArrayList(aclBindings.size());
        AclMutator aclMutator = this.aclMutatorOrException();
        aclBindings.forEach(b -> futures.add(new CompletableFuture()));
        ControllerRequestContext context = new ControllerRequestContext(requestContext, OptionalLong.empty());
        aclMutator.createAcls(context, aclBindings).whenComplete((results, throwable) -> {
            if (throwable == null && results.size() != futures.size()) {
                throwable = new UnknownServerException("Invalid size of result set from controller. Expected " + futures.size() + "; got " + results.size());
            }
            if (throwable == null) {
                for (int i = 0; i < futures.size(); ++i) {
                    ((CompletableFuture)futures.get(i)).complete((AclCreateResult)results.get(i));
                }
            } else {
                for (CompletableFuture future : futures) {
                    ApiException e = throwable instanceof ApiException ? (ApiException)((Object)throwable) : ApiError.fromThrowable((Throwable)throwable).exception();
                    future.complete(new AclCreateResult(e));
                }
            }
        });
        return futures;
    }

    default public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> filters) {
        ArrayList futures = new ArrayList(filters.size());
        AclMutator aclMutator = this.aclMutatorOrException();
        filters.forEach(b -> futures.add(new CompletableFuture()));
        ControllerRequestContext context = new ControllerRequestContext(requestContext, OptionalLong.empty());
        aclMutator.deleteAcls(context, filters).whenComplete((results, throwable) -> {
            if (throwable == null && results.size() != futures.size()) {
                throwable = new UnknownServerException("Invalid size of result set from controller. Expected " + futures.size() + "; got " + results.size());
            }
            if (throwable == null) {
                for (int i = 0; i < futures.size(); ++i) {
                    ((CompletableFuture)futures.get(i)).complete((AclDeleteResult)results.get(i));
                }
            } else {
                for (CompletableFuture future : futures) {
                    ApiException e = throwable instanceof ApiException ? (ApiException)((Object)throwable) : ApiError.fromThrowable((Throwable)throwable).exception();
                    future.complete(new AclDeleteResult(e));
                }
            }
        });
        return futures;
    }
}

