/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.changeSignature.CallerChooserBase;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinMethodNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0014\u0010\n\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ8\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u001a\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0013j\n\u0012\u0004\u0012\u00020\u0002\u0018\u0001`\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014JG\u0010\u0017\u001a4\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0018\u0001 \u001a*\u0019\u0012\u000e\b\u0001\u0012\n \u001a*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u0018\u00a2\u0006\u0002\b\u001b0\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0007H\u0014J\b\u0010\u001e\u001a\u00020\u0007H\u0014\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallerChooser;", "Lcom/intellij/refactoring/changeSignature/CallerChooserBase;", "Lcom/intellij/psi/PsiElement;", "declaration", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "previousTree", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/ui/treeStructure/Tree;Lcom/intellij/util/Consumer;)V", "createTreeNodeFor", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinMethodNode;", "method", "called", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "cancelCallback", "Ljava/lang/Runnable;", "findDeepestSuperMethods", "", "Lcom/intellij/psi/PsiMethod;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiMethod;", "getEmptyCallerText", "getEmptyCalleeText", "kotlin.idea"})
public final class KotlinCallerChooser
extends CallerChooserBase<PsiElement> {
    public KotlinCallerChooser(@NotNull PsiElement declaration, @NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @Nullable Tree previousTree, @NotNull Consumer<? super Set<? extends PsiElement>> callback2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        super(declaration, project, title, previousTree, "dummy.kt", callback2);
    }

    @NotNull
    protected KotlinMethodNode createTreeNodeFor(@Nullable PsiElement method, @Nullable HashSet<PsiElement> called, @Nullable Runnable cancelCallback) {
        HashSet<PsiElement> hashSet = called;
        if (hashSet == null) {
            hashSet = new HashSet<PsiElement>();
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Runnable runnable = cancelCallback;
        if (runnable == null) {
            runnable = KotlinCallerChooser::createTreeNodeFor$lambda$0;
        }
        return new KotlinMethodNode(method, hashSet, project, runnable);
    }

    @Nullable
    protected PsiMethod[] findDeepestSuperMethods(@NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiMethod psiMethod = (PsiMethod)CollectionsKt.singleOrNull((List)LightClassUtilsKt.toLightMethods((PsiElement)method));
        return psiMethod != null ? psiMethod.findDeepestSuperMethods() : null;
    }

    @NotNull
    protected String getEmptyCallerText() {
        return KotlinBundle.message((String)"text.caller.text.with.highlighted.callee.call.would.be.shown.here", (Object[])new Object[0]);
    }

    @NotNull
    protected String getEmptyCalleeText() {
        return KotlinBundle.message((String)"text.callee.text.would.be.shown.here", (Object[])new Object[0]);
    }

    private static final void createTreeNodeFor$lambda$0() {
    }
}

