/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirContextSensitiveResolutionAmbiguityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.ContextSensitiveResolutionKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContextSensitiveResolutionAmbiguityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContextSensitiveResolutionAmbiguityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,127:1\n59#2:128\n*S KotlinDebug\n*F\n+ 1 FirContextSensitiveResolutionAmbiguityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators\n*L\n104#1:128\n*E\n"})
public final class FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators INSTANCE = new FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators();

    private FirContextSensitiveResolutionAmbiguityCheckerForTypeOperators() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeOperatorCall expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (!LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ContextSensitiveResolutionUsingExpectedType)) {
            return;
        }
        FirTypeRef firTypeRef = expression.getConversionTypeRef();
        FirResolvedTypeRef firResolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (firResolvedTypeRef == null) {
            return;
        }
        FirResolvedTypeRef typeRef = firResolvedTypeRef;
        if (!FirContextSensitiveResolutionAmbiguityCheckerKt.access$getShouldWarn(typeRef.getResolvedSymbolOrigin()) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.toClassLikeSymbol(typeRef, context2.getSession());
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> resolvedClass = firClassLikeSymbol;
        FirTypeRef firTypeRef2 = typeRef.getDelegatedTypeRef();
        Object object = firTypeRef2 instanceof FirUserTypeRef ? (FirUserTypeRef)firTypeRef2 : null;
        if (object == null || (object = ((FirUserTypeRef)object).getQualifier()) == null || (object = (FirQualifierPart)CollectionsKt.singleOrNull((List)object)) == null || (object = object.getName()) == null) {
            return;
        }
        Object name2 = object;
        FirCall $this$argument$iv = expression;
        boolean $i$f$getArgument = false;
        for (FirRegularClassSymbol classToLookAt : ContextSensitiveResolutionKt.getParentChainForContextSensitiveResolutionOfTypes(FirTypeUtilsKt.getResolvedType((FirExpression)CollectionsKt.first($this$argument$iv.getArgumentList().getArguments())), context2.getSession())) {
            List<FirClassifierSymbol<?>> nestedClassifierSymbols = FirScopeKt.getClassifiers(FirHelpersKt.declaredMemberScope(context2, classToLookAt), (Name)name2);
            if (nestedClassifierSymbols.isEmpty()) continue;
            if (!nestedClassifierSymbols.contains(resolvedClass)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)typeRef.getSource()), FirErrors.INSTANCE.getCONTEXT_SENSITIVE_RESOLUTION_AMBIGUITY(), resolvedClass, nestedClassifierSymbols, null, (int)32, null);
            }
            return;
        }
    }
}

