/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.PackageMatcher;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

class ClassNameMatcher {
    private final PackageMatcher packageMatcher;
    private final Optional<String> name;
    private final boolean ignoresClasses;
    private final boolean matchesSingleClasses;
    private final String pattern;

    ClassNameMatcher(String pattern, boolean ignoresClasses, boolean matchesSingleClasses, Optional<String> name) {
        this.pattern = pattern;
        this.matchesSingleClasses = matchesSingleClasses;
        this.packageMatcher = PackageMatcher.of((String)pattern);
        this.name = name;
        this.ignoresClasses = ignoresClasses;
    }

    boolean isIgnored(JavaClass javaClass) {
        return this.ignoresClasses && this.packageMatcher.matches(this.qualifiedClassName(javaClass));
    }

    Optional<String> toGroup(JavaClass javaClass) {
        Optional<String> joinedNameParts = this.packageMatcher.match(this.qualifiedClassName(javaClass)).map(PackageMatcher.TO_GROUPS).map(Collection::stream).map(s -> s.collect(Collectors.joining(":")));
        return joinedNameParts.map(parts -> this.name.map(s -> s + " " + parts).orElse((String)parts));
    }

    private String qualifiedClassName(JavaClass javaClass) {
        int lastIndexOfNon$;
        if (!this.matchesSingleClasses) {
            return javaClass.getPackageName();
        }
        String fullName = CodeNode.findEnclosingTopLevelClass(javaClass).getName();
        for (lastIndexOfNon$ = fullName.length() - 1; lastIndexOfNon$ > 0 && fullName.charAt(lastIndexOfNon$) == '$'; --lastIndexOfNon$) {
        }
        return fullName.substring(0, lastIndexOfNon$ + 1);
    }

    public boolean ignoresClasses() {
        return this.ignoresClasses;
    }

    public int hashCode() {
        return Objects.hash(this.ignoresClasses, this.name, this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassNameMatcher other = (ClassNameMatcher)obj;
        return this.ignoresClasses == other.ignoresClasses && Objects.equals(this.name, other.name) && Objects.equals(this.pattern, other.pattern);
    }
}

