/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedTypeAdapterInitializer;
import proguard.util.MultiValueMap;

public class OptimizedTypeAdapterAdder
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationInfo;
    private final OptimizedJsonInfo deserializationInfo;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final Map<String, String> typeAdapterRegistry;
    private final ClassPool instanceCreatorClassPool;

    public OptimizedTypeAdapterAdder(ClassPool programClassPool, ClassPool libraryClassPool, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo serializationInfo, OptimizedJsonInfo deserializationInfo, MultiValueMap<String, String> injectedClassNameMap, Map<String, String> typeAdapterRegistry, ClassPool instanceCreatorClassPool) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationInfo = serializationInfo;
        this.deserializationInfo = deserializationInfo;
        this.injectedClassNameMap = injectedClassNameMap;
        this.typeAdapterRegistry = typeAdapterRegistry;
        this.instanceCreatorClassPool = instanceCreatorClassPool;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String externalClassName = ClassUtil.externalClassName(programClass.getName());
        String packageName = ClassUtil.externalPackageName(externalClassName);
        String shortClassName = ClassUtil.externalShortClassName(externalClassName);
        String externalTypeAdapterClassName = packageName + '.' + "Optimized" + shortClassName + "TypeAdapter";
        String typeAdapterClassName = ClassUtil.internalClassName(externalTypeAdapterClassName);
        if (this.programClassPool.getClass(typeAdapterClassName) == null) {
            ClassReader templateClassReader = new ClassReader(false, false, false, null, new OptimizedTypeAdapterInitializer(typeAdapterClassName, programClass, this.codeAttributeEditor, this.serializationInfo, this.deserializationInfo, this.instanceCreatorClassPool, new MultiClassVisitor(new ClassPresenceFilter(this.programClassPool, null, new ClassPoolFiller(this.programClassPool)), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer())));
            try {
                String dataEntryName = OptimizedTypeAdapterAdder.getDataEntryName("proguard/optimize/gson/_OptimizedTypeAdapterImpl");
                templateClassReader.read(new ClassPathDataEntry(dataEntryName));
                this.injectedClassNameMap.put(programClass.getName(), typeAdapterClassName);
                this.typeAdapterRegistry.put(programClass.getName(), typeAdapterClassName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private static String getDataEntryName(String internalClassName) {
        return internalClassName + ".class";
    }
}

