/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.opensearch.action.admin.cluster.shards.ClusterSearchShardsGroup;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.internal.AliasFilter;

@PublicApi(since="1.0.0")
public class ClusterSearchShardsResponse
extends ActionResponse
implements ToXContentObject {
    private final ClusterSearchShardsGroup[] groups;
    private final DiscoveryNode[] nodes;
    private final Map<String, AliasFilter> indicesAndFilters;

    public ClusterSearchShardsResponse(StreamInput in) throws IOException {
        super(in);
        this.groups = (ClusterSearchShardsGroup[])in.readArray(ClusterSearchShardsGroup::new, ClusterSearchShardsGroup[]::new);
        this.nodes = (DiscoveryNode[])in.readArray(DiscoveryNode::new, DiscoveryNode[]::new);
        this.indicesAndFilters = in.readMap(StreamInput::readString, AliasFilter::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.groups);
        out.writeArray((Writeable[])this.nodes);
        out.writeMap(this.indicesAndFilters, StreamOutput::writeString, (o, s) -> s.writeTo(o));
    }

    public ClusterSearchShardsResponse(ClusterSearchShardsGroup[] groups, DiscoveryNode[] nodes, Map<String, AliasFilter> indicesAndFilters) {
        this.groups = groups;
        this.nodes = nodes;
        this.indicesAndFilters = indicesAndFilters;
    }

    public ClusterSearchShardsGroup[] getGroups() {
        return this.groups;
    }

    public DiscoveryNode[] getNodes() {
        return this.nodes;
    }

    public Map<String, AliasFilter> getIndicesAndFilters() {
        return this.indicesAndFilters;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("nodes");
        for (DiscoveryNode node : this.nodes) {
            node.toXContent(builder, params);
        }
        builder.endObject();
        if (this.indicesAndFilters != null) {
            builder.startObject("indices");
            for (Map.Entry entry : this.indicesAndFilters.entrySet()) {
                String index = (String)entry.getKey();
                builder.startObject(index);
                AliasFilter aliasFilter = (AliasFilter)entry.getValue();
                Object[] aliases = aliasFilter.getAliases();
                if (aliases.length > 0) {
                    Arrays.sort(aliases);
                    builder.array("aliases", (String[])aliases);
                    if (aliasFilter.getQueryBuilder() != null) {
                        builder.field("filter");
                        aliasFilter.getQueryBuilder().toXContent(builder, params);
                    }
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.startArray("shards");
        for (ClusterSearchShardsGroup group : this.groups) {
            group.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

