#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-6tymVBwXTsFKOTX6cYSmMy
key:                  tree-diff-0.3.0.1-6tymVBwXTsFKOTX6cYSmMy
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  451ef574a519ad0e24414a85f0bcd360
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-6tymVBwXTsFKOTX6cYSmMy
depends:
    QuickCheck-2.15.0.1-4mIWiyi0MCz4O9NEuBQDps
    aeson-2.1.2.1-JZeWX2s1eQL7Ta3HF3w6fW
    ansi-terminal-1.0.2-3wM6DfsGeit89xAznbDC0C
    ansi-wl-pprint-1.0.2-95YnaC3fNbfLsNzVSxIj4T base-4.18.2.1
    base-compat-0.14.1-4heBy5B59ewBpEOwRrJlc4 bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.1
    hashable-1.4.7.0-L2Cc1YdcpYH9U2sZW5osde parsec-3.1.16.1
    parsers-0.12.12-9uOKlEBWK86NuVEBiBC6i pretty-1.1.3.6
    primitive-0.9.1.0-LZUymL07sjCJKODqCvDEyu
    scientific-0.3.8.0-7SlgUkp6kxxBFUUY5SNCvh
    semialign-1.3.1-LfdxsIEcbJ24IMbi0eQiM4
    strict-0.5.1-99YwymyCbNwBF5Zcur3zh2
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig text-2.0.2
    these-1.2.1-Jr1OKOvwflFL3mHngmLVvf time-1.12.2
    unordered-containers-0.2.20.1-8SON4238u8N3rDHPceHjHx
    uuid-types-1.0.6-LOdMhlcFsFOnVrhLe64Jq
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

